/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.config.ConfigException;
import com.caucho.vfs.Path;
import java.io.IOException;
import java.util.ArrayList;
import java.util.TreeSet;
import java.util.logging.Logger;

class ExpandDirectoryManager {
    private static final Logger log = Logger.getLogger(ExpandDirectoryManager.class.getName());
    private final String _id;
    private final Path _expandDirectory;
    private final String _expandPrefix;
    private final String _expandSuffix;
    private final ArrayList<String> _requireFiles = new ArrayList();
    private long _digest;
    private TreeSet<String> _keySet = new TreeSet();

    public ExpandDirectoryManager(String id, Path expandDirectory, String expandPrefix, String expandSuffix, ArrayList<String> requireFiles) {
        this._id = id;
        this._expandDirectory = expandDirectory;
        this._expandPrefix = expandPrefix;
        this._expandSuffix = expandSuffix;
        this._requireFiles.addAll(requireFiles);
    }

    void reset() {
        this._digest = -1L;
        this._keySet = new TreeSet();
    }

    public String getId() {
        return this._id;
    }

    public Path getExpandDirectory() {
        return this._expandDirectory;
    }

    public String getExpandPrefix() {
        return this._expandPrefix;
    }

    public String getExpandSuffix() {
        return this._expandSuffix;
    }

    Path getExpandPath(String key) {
        String pathName = this.getExpandPrefix() + key + this.getExpandSuffix();
        Path path = this.getExpandDirectory().lookup(pathName);
        return path;
    }

    TreeSet<String> getDeployedKeys() {
        long oldDigest = this._digest;
        TreeSet<String> oldKeys = this._keySet;
        long newDigest = this.getDigest();
        if (oldDigest == newDigest) {
            return oldKeys;
        }
        try {
            TreeSet<String> newKeys = this.scanKeys();
            this._digest = newDigest;
            this._keySet = newKeys;
            return newKeys;
        }
        catch (Exception e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    boolean isModified() {
        return this._digest != this.getDigest();
    }

    boolean logModified(Logger log) {
        if (this.isModified()) {
            log.info(this + " is modified");
            return true;
        }
        return false;
    }

    long getDigest() {
        return this.getExpandDirectory().getCrc64();
    }

    private TreeSet<String> scanKeys() throws IOException {
        TreeSet<String> keys = new TreeSet<String>();
        for (String pathName : this.getExpandDirectory().list()) {
            Path rootDirectory;
            if (!pathName.startsWith(this._expandPrefix) || !pathName.startsWith(this._expandSuffix) || !this.isValidDirectory(rootDirectory = this.getExpandDirectory().lookup(pathName), pathName)) continue;
            int begin = this._expandPrefix.length();
            int end = pathName.length() - this._expandSuffix.length();
            String key = pathName.substring(begin, end);
            keys.add(key);
        }
        return keys;
    }

    private boolean isValidDirectory(Path rootDirectory, String pathName) {
        if (!rootDirectory.isDirectory()) {
            return false;
        }
        if (pathName.equalsIgnoreCase("web-inf") || pathName.equalsIgnoreCase("meta-inf") || pathName.startsWith(".") || pathName.endsWith(".")) {
            return false;
        }
        if (this._expandPrefix.equals("") && pathName.startsWith("_")) {
            return false;
        }
        for (int j = 0; j < this._requireFiles.size(); ++j) {
            String file = this._requireFiles.get(j);
            if (rootDirectory.lookup(file).canRead()) continue;
            return false;
        }
        Path expandHash = rootDirectory.lookup("META-INF/resin.application-hash");
        if (expandHash.canRead()) {
            log.finer(this + " " + rootDirectory + " contains an application hash");
            return false;
        }
        return true;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getExpandDirectory() + "]";
    }
}

