/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.config.ConfigException;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.types.PathBuilder;
import com.caucho.env.deploy.DeployConfig;
import com.caucho.env.deploy.DeployContainerApi;
import com.caucho.env.deploy.DeployControllerAdmin;
import com.caucho.env.deploy.DeployControllerApi;
import com.caucho.env.deploy.EnvironmentDeployInstance;
import com.caucho.env.deploy.ExpandDeployController;
import com.caucho.env.repository.RepositoryTagEntry;
import com.caucho.jmx.Jmx;
import com.caucho.loader.DynamicClassLoader;
import com.caucho.loader.Environment;
import com.caucho.loader.EnvironmentClassLoader;
import com.caucho.loader.EnvironmentListener;
import com.caucho.util.L10N;
import com.caucho.vfs.Path;
import com.caucho.vfs.Vfs;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeMap;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.el.ELException;
import javax.management.ObjectName;

public abstract class EnvironmentDeployController<I extends EnvironmentDeployInstance, C extends DeployConfig>
extends ExpandDeployController<I>
implements EnvironmentListener {
    private static final L10N L = new L10N(EnvironmentDeployController.class);
    private static final Logger log = Logger.getLogger(EnvironmentDeployController.class.getName());
    private LinkedHashMap<String, String> _jmxContext;
    private Object _mbean;
    private ObjectName _objectName;
    private ArrayList<C> _configDefaults = new ArrayList();
    private C _config;
    private DeployConfig _prologue;
    private HashMap<String, Object> _variableMap = new HashMap();
    private Throwable _configException;

    public EnvironmentDeployController(String id, Path rootDirectory) {
        this(id, rootDirectory, null, null);
    }

    public EnvironmentDeployController(String id, Path rootDirectory, C config, DeployContainerApi<?> container) {
        super(id, null, rootDirectory, container);
        this._jmxContext = Jmx.copyContextProperties((ClassLoader)this.getParentClassLoader());
        this.setConfig(config);
    }

    public void setConfig(C config) {
        if (config == null) {
            return;
        }
        if (this._config != null && !this._configDefaults.contains(this._config)) {
            this.addConfigDefault(this._config);
        }
        this.addConfigController(config);
        this._config = config;
        if (this._prologue == null) {
            this.setPrologue(((DeployConfig)config).getPrologue());
        }
    }

    public C getConfig() {
        return this._config;
    }

    public DeployConfig getPrologue() {
        return this._prologue;
    }

    public void setPrologue(DeployConfig prologue) {
        this._prologue = prologue;
    }

    public String getErrorMessage() {
        Throwable exn = this.getConfigException();
        if (exn instanceof ConfigException) {
            exn.printStackTrace();
            return exn.getMessage();
        }
        if (exn != null) {
            exn.printStackTrace();
            return exn.toString();
        }
        return null;
    }

    @Override
    public Throwable getConfigException() {
        Object deploy;
        Throwable configException = super.getConfigException();
        if (configException == null) {
            configException = this._configException;
        }
        if (configException == null && (deploy = this.getDeployInstance()) != null) {
            configException = deploy.getConfigException();
        }
        return configException;
    }

    public void addConfigDefault(C config) {
        if (!this._configDefaults.contains(config)) {
            this._configDefaults.add(config);
            this.addConfigController(config);
        }
    }

    private void addConfigController(C config) {
        if (((DeployConfig)config).getStartupMode() != null) {
            this.setStartupMode(((DeployConfig)config).getStartupMode());
        }
        if (((DeployConfig)config).getRedeployCheckInterval() != null) {
            this.setRedeployCheckInterval(((DeployConfig)config).getRedeployCheckInterval());
        }
        if (((DeployConfig)config).getRedeployMode() != null) {
            this.setRedeployMode(((DeployConfig)config).getRedeployMode());
        }
        if (((DeployConfig)config).getExpandCleanupFileset() != null) {
            this.addParentExpandCleanupFileSet(((DeployConfig)config).getExpandCleanupFileset());
        }
    }

    public HashMap<String, Object> getVariableMap() {
        return this._variableMap;
    }

    public Object getMBean() {
        return this._mbean;
    }

    public ObjectName getObjectName() {
        return this._objectName;
    }

    public void setConfigException(Throwable e) {
        this._configException = e;
        if (this.getDeployInstance() != null) {
            ((EnvironmentDeployInstance)this.getDeployInstance()).setConfigException(e);
        }
    }

    @Override
    protected void initEnd() {
        super.initEnd();
        if (this.getDeployAdmin() != null) {
            this.getDeployAdmin().register();
        }
    }

    @Override
    public boolean isNameMatch(String url) {
        return url.equals(this.getId());
    }

    protected String getMBeanTypeName() {
        return ((EnvironmentDeployInstance)this.getDeployInstance()).getClass().getSimpleName();
    }

    protected String getMBeanId() {
        String name = this.getId();
        if (name == null || name.equals("")) {
            name = "default";
        }
        return name;
    }

    @Override
    public void merge(DeployControllerApi<I> oldControllerV) {
        EnvironmentDeployController oldController = (EnvironmentDeployController)oldControllerV;
        if (!this.getRootDirectory().equals((Object)oldController.getRootDirectory())) {
            return;
        }
        super.merge(oldControllerV);
        ArrayList<DeployConfig> configDefaults = new ArrayList<DeployConfig>();
        if (this.getPrologue() == null) {
            this.setPrologue(oldController.getPrologue());
        } else if (oldController.getPrologue() != null) {
            configDefaults.add(0, this.getPrologue());
            this.setPrologue(oldController.getPrologue());
        }
        configDefaults.addAll(oldController._configDefaults);
        if (this.getConfig() == null) {
            this.setConfig(oldController.getConfig());
        } else if (oldController.getConfig() != null) {
            configDefaults.add((DeployConfig)this.getConfig());
            this.setConfig(oldController.getConfig());
        }
        for (DeployConfig config : this._configDefaults) {
            if (configDefaults.contains(config)) continue;
            configDefaults.add(config);
        }
        this._configDefaults = configDefaults;
    }

    protected DeployControllerAdmin<?> getDeployAdmin() {
        return null;
    }

    @Override
    public boolean destroy() {
        if (!super.destroy()) {
            return false;
        }
        Environment.removeEnvironmentListener((EnvironmentListener)this, (ClassLoader)this.getParentClassLoader());
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            thread.setContextClassLoader(this.getParentClassLoader());
            if (this.getDeployAdmin() != null) {
                this.getDeployAdmin().unregister();
            }
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void configureInstance(I instance) throws Exception {
        Thread thread = Thread.currentThread();
        ClassLoader oldLoader = thread.getContextClassLoader();
        try {
            ConfigProgram program;
            ClassLoader classLoader = instance.getClassLoader();
            thread.setContextClassLoader(classLoader);
            log.fine(instance + " initializing");
            super.configureInstance(instance);
            instance.setConfigException(this._configException);
            this.extendJMXContext(this._jmxContext);
            Jmx.setContextProperties(this._jmxContext, (ClassLoader)classLoader);
            this.configureInstanceVariables(instance);
            ArrayList<DeployConfig> initList = new ArrayList<DeployConfig>();
            if (this.getPrologue() != null) {
                initList.add(this.getPrologue());
            }
            ClassLoader loader = instance.getClassLoader();
            thread.setContextClassLoader(loader);
            Vfs.setPwd((Path)this.getRootDirectory());
            this.addDependencies();
            instance.preConfigInit();
            this.fillInitList(initList);
            InjectManager cdiManager = InjectManager.getCurrent();
            cdiManager.setEnableAutoUpdate(false);
            try {
                for (DeployConfig config : initList) {
                    program = config.getClassLoaderProgram();
                    if (program == null) continue;
                    program.configure(instance);
                }
            }
            finally {
                cdiManager.setEnableAutoUpdate(true);
            }
            if (loader instanceof DynamicClassLoader) {
                DynamicClassLoader dynLoader = (DynamicClassLoader)loader;
                dynLoader.updateScan();
            }
            for (DeployConfig config : initList) {
                program = config.getBuilderProgram();
                if (program == null) continue;
                program.configure(instance);
            }
            instance.init();
        }
        finally {
            thread.setContextClassLoader(oldLoader);
        }
    }

    protected void extendJMXContext(Map<String, String> context) {
    }

    protected void fillInitList(ArrayList<DeployConfig> initList) {
        boolean isSkipDefault;
        boolean bl = isSkipDefault = this._config != null && ((DeployConfig)this._config).isSkipDefaultConfig();
        if (isSkipDefault) {
            initList.clear();
        } else {
            for (DeployConfig config : this._configDefaults) {
                DeployConfig prologue = config.getPrologue();
                if (prologue == null) continue;
                initList.add(prologue);
            }
            initList.addAll(this._configDefaults);
        }
        if (this._config != null && !initList.contains(this._config)) {
            initList.add((DeployConfig)this._config);
        }
    }

    protected void configureInstanceVariables(I instance) {
        Path rootDirectory = this.getRootDirectory();
        if (rootDirectory == null) {
            throw new NullPointerException("Null root directory");
        }
        if (rootDirectory.isFile()) {
            if (rootDirectory.getPath().endsWith(".jar") || rootDirectory.getPath().endsWith(".war")) {
                throw new ConfigException(L.l("root-directory `{0}' must specify a directory.  It may not be a .jar or .war.", (Object)rootDirectory.getPath()));
            }
            throw new ConfigException(L.l("root-directory `{0}' may not be a file.  root-directory must specify a directory.", (Object)rootDirectory.getPath()));
        }
        Vfs.setPwd((Path)rootDirectory);
        if (log.isLoggable(Level.FINE)) {
            log.fine(instance + " root-directory=" + rootDirectory);
        }
    }

    public Map<String, String> getRepositoryMetaData() {
        TreeMap<String, String> map = new TreeMap<String, String>();
        Map<String, RepositoryTagEntry> tagMap = this.getRepository().getTagMap();
        RepositoryTagEntry entry = tagMap.get(this.getId());
        if (entry == null && this.getAutoDeployTag() != null) {
            entry = tagMap.get(this.getAutoDeployTag());
        }
        if (entry != null) {
            map.putAll(entry.getAttributeMap());
        }
        return map;
    }

    public String[] getClassPath() {
        EnvironmentDeployInstance instance = (EnvironmentDeployInstance)this.getDeployInstance();
        if (instance == null) {
            return null;
        }
        ClassLoader loader = instance.getClassLoader();
        if (!(loader instanceof DynamicClassLoader)) {
            log.finer(this + " " + loader + " is not a DynamicClassLoader");
            return null;
        }
        DynamicClassLoader dynLoader = (DynamicClassLoader)loader;
        ArrayList classPathList = new ArrayList();
        dynLoader.buildClassPath(classPathList);
        String[] classPath = new String[classPathList.size()];
        classPathList.toArray(classPath);
        return classPath;
    }

    @Override
    public Path getArchivePath() {
        Path path = super.getArchivePath();
        if (path != null) {
            return path;
        }
        if (this._config != null) {
            String pathString = ((DeployConfig)this._config).getArchivePath();
            if (pathString != null) {
                try {
                    path = PathBuilder.lookupPath((String)pathString);
                }
                catch (ELException e) {
                    throw new RuntimeException(e);
                }
            }
            this.setArchivePath(path);
        }
        return path;
    }

    public void environmentConfigure(EnvironmentClassLoader loader) {
    }

    public void environmentBind(EnvironmentClassLoader loader) {
    }

    public void environmentStart(EnvironmentClassLoader loader) {
        try {
            this.start();
        }
        catch (Exception e) {
            log.log(Level.WARNING, e.toString(), e);
        }
    }

    public void environmentStop(EnvironmentClassLoader loader) {
        this.stop();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "$" + System.identityHashCode(this) + "[" + this.getId() + "]";
    }
}

