/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.deploy;

import com.caucho.env.deploy.DeployContainer;
import com.caucho.env.deploy.DeployControllerApi;
import com.caucho.env.deploy.DeployGenerator;
import com.caucho.vfs.Dependency;
import java.util.ArrayList;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeployListGenerator<E extends DeployControllerApi<?>>
extends DeployGenerator<E>
implements Dependency {
    private static final Logger log = Logger.getLogger(DeployListGenerator.class.getName());
    private ArrayList<DeployGenerator<E>> _generatorList = new ArrayList();

    public DeployListGenerator(DeployContainer<E> container) {
        super(container);
    }

    public void add(DeployGenerator<E> deploy) {
        if (!this._generatorList.contains(deploy)) {
            this._generatorList.add(deploy);
        }
    }

    public void remove(DeployGenerator<E> deploy) {
        this._generatorList.remove(deploy);
    }

    @Override
    public boolean isModified() {
        for (int i = this._generatorList.size() - 1; i >= 0; --i) {
            if (!this._generatorList.get(i).isModified()) continue;
            return true;
        }
        return false;
    }

    @Override
    public boolean logModified(Logger log) {
        for (int i = this._generatorList.size() - 1; i >= 0; --i) {
            if (!this._generatorList.get(i).logModified(log)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void updateIfModified() {
        for (int i = this._generatorList.size() - 1; i >= 0; --i) {
            this._generatorList.get(i).updateIfModified();
        }
    }

    @Override
    public void update() {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).update();
        }
    }

    @Override
    public void fillDeployedNames(Set<String> keys) {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).fillDeployedNames(keys);
        }
    }

    @Override
    protected void generateController(String key, ArrayList<E> controllers) {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).generateController(key, controllers);
        }
    }

    @Override
    protected void mergeController(E controller, String key) {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).mergeController(controller, key);
        }
    }

    @Override
    protected void startImpl() {
        super.startImpl();
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).start();
        }
    }

    @Override
    protected void stopImpl() {
        for (int i = 0; i < this._generatorList.size(); ++i) {
            this._generatorList.get(i).stop();
        }
        super.stopImpl();
    }

    @Override
    protected void destroyImpl() {
        ArrayList<DeployGenerator<E>> generatorList = new ArrayList<DeployGenerator<E>>(this._generatorList);
        this._generatorList.clear();
        for (int i = 0; i < generatorList.size(); ++i) {
            try {
                generatorList.get(i).destroy();
                continue;
            }
            catch (Throwable e) {
                log.log(Level.FINE, e.toString(), e);
            }
        }
        super.destroyImpl();
    }

    @Override
    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._generatorList + "]";
    }
}

