/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.env.dbpool;

import com.caucho.env.dbpool.ConnectionPool;
import com.caucho.env.dbpool.ManagedPoolItem;
import com.caucho.transaction.ManagedResource;
import com.caucho.transaction.UserTransactionImpl;
import com.caucho.util.L10N;
import javax.resource.ResourceException;
import javax.resource.spi.ConnectionEvent;
import javax.resource.spi.ConnectionRequestInfo;
import javax.resource.spi.ManagedConnectionFactory;
import javax.security.auth.Subject;
import javax.transaction.RollbackException;

class UserPoolItem
implements ManagedResource {
    private static final L10N L = new L10N(UserPoolItem.class);
    private ConnectionPool _cm;
    private String _id;
    private ManagedPoolItem _ownPoolItem;
    private ManagedConnectionFactory _mcf;
    private Subject _subject;
    private ConnectionRequestInfo _info;
    private UserTransactionImpl _transaction;
    private ManagedPoolItem _sharePoolItem;
    private UserPoolItem _shareNext;
    private UserPoolItem _sharePrev;
    private Object _userConn;
    private boolean _hasConnectionError;
    private IllegalStateException _allocationStackTrace;

    public UserPoolItem(ConnectionPool cm) {
        this._cm = cm;
        this._id = this._cm.generateId();
        this._transaction = this._cm.getTransaction();
        if (cm.getSaveAllocationStackTrace()) {
            this._allocationStackTrace = new IllegalStateException(L.l("unclosed connection: " + this + " was allocated at"));
            this._allocationStackTrace.fillInStackTrace();
        }
    }

    public UserPoolItem(ConnectionPool cm, ManagedPoolItem poolItem) {
        this(cm);
        this._ownPoolItem = poolItem;
        this._sharePoolItem = poolItem;
    }

    public void setManagedConnectionFactory(ManagedConnectionFactory mcf) {
        this._mcf = mcf;
    }

    public ManagedConnectionFactory getManagedConnectionFactory() {
        return this._mcf;
    }

    public void setSubject(Subject subject) {
        this._subject = subject;
    }

    public Subject getSubject() {
        return this._subject;
    }

    public void setInfo(ConnectionRequestInfo info) {
        this._info = info;
    }

    public ConnectionRequestInfo getInfo() {
        return this._info;
    }

    public boolean isActive() {
        return this._userConn != null;
    }

    public void connectionErrorOccurred(ConnectionEvent event) {
        this._hasConnectionError = true;
    }

    public boolean isConnectionError() {
        return this._hasConnectionError;
    }

    public IllegalStateException getAllocationStackTrace() {
        return this._allocationStackTrace;
    }

    public void setSaveAllocationStackTrace(boolean enable) {
        this._cm.setSaveAllocationStackTrace(enable);
    }

    public boolean isCloseDanglingConnections() {
        return this._cm.isCloseDanglingConnections();
    }

    public ManagedPoolItem getOwnPoolItem() {
        return this._ownPoolItem;
    }

    void setOwnPoolItem(ManagedPoolItem poolItem) {
        assert (this._ownPoolItem == null);
        this._ownPoolItem = poolItem;
        this._sharePoolItem = poolItem;
    }

    public ManagedPoolItem getXAResource() {
        return this._sharePoolItem;
    }

    public Object getUserConnection() {
        return this._userConn;
    }

    Object allocateUserConnection() throws ResourceException {
        if (this._userConn == null) {
            this._userConn = this._sharePoolItem.allocateConnection();
        }
        return this._userConn;
    }

    public void setUserConnection(Object userConn) {
        this._userConn = userConn;
    }

    UserPoolItem getShareNext() {
        return this._shareNext;
    }

    void setShareNext(UserPoolItem next) {
        this._shareNext = next;
    }

    void associatePoolItem(ManagedPoolItem poolItem) {
        if (this._ownPoolItem != null) {
            throw new IllegalStateException(L.l("associating with old pool item."));
        }
        this._ownPoolItem = poolItem;
        if (this._sharePoolItem != null) {
            this.removeFromShareList();
        }
        this.addToShareList(poolItem);
    }

    void associate(ManagedPoolItem poolItem, ManagedConnectionFactory mcf, Subject subject, ConnectionRequestInfo info) {
        if (this._sharePoolItem != null) {
            this.removeFromShareList();
        }
        this._mcf = mcf;
        this._subject = subject;
        this._info = info;
        this.addToShareList(poolItem);
        if (this._transaction != null) {
            try {
                this._transaction.enlistResource((ManagedResource)this);
            }
            catch (RollbackException e) {
                this.removeFromShareList();
                poolItem.toIdle();
                throw new RuntimeException(e);
            }
            catch (Throwable e) {
                this.removeFromShareList();
                poolItem.setConnectionError();
                poolItem.toIdle();
                throw new RuntimeException(e);
            }
        }
    }

    void reassociatePoolItem() throws ResourceException {
        if (this._ownPoolItem == null) {
            UserPoolItem item = this._cm.allocatePoolConnection(this._mcf, this._subject, this._info, this);
            assert (item == this);
            this._ownPoolItem = item.getOwnPoolItem();
        }
        if (this._sharePoolItem != null) {
            this.removeFromShareList();
        }
        this.addToShareList(this._ownPoolItem);
    }

    public void abortConnection() {
        ManagedPoolItem poolItem = this._ownPoolItem;
        this._ownPoolItem = null;
        this.removeFromShareList();
        if (poolItem != null) {
            poolItem.abortConnection();
        }
    }

    void toIdle() {
        ManagedPoolItem poolItem = this._ownPoolItem;
        this._ownPoolItem = null;
        this.removeFromShareList();
        if (poolItem != null) {
            poolItem.toIdle();
        }
    }

    void clearTransaction() {
        if (this._transaction != null) {
            this._transaction.delistResource((ManagedResource)this);
        }
    }

    void close() {
        this._ownPoolItem = null;
        this._userConn = null;
        if (this._transaction != null) {
            this._transaction.delistResource((ManagedResource)this);
        }
        this.removeFromShareList();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void removeFromShareList() {
        ManagedPoolItem poolItem = this._sharePoolItem;
        this._sharePoolItem = null;
        if (poolItem == null) {
            return;
        }
        Object object = poolItem._shareLock;
        synchronized (object) {
            UserPoolItem prev = this._sharePrev;
            UserPoolItem next = this._shareNext;
            this._sharePrev = null;
            this._shareNext = null;
            if (prev != null) {
                prev._shareNext = next;
            } else {
                poolItem._shareHead = next;
            }
            if (next != null) {
                next._sharePrev = prev;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void addToShareList(ManagedPoolItem poolItem) {
        if (this._sharePoolItem != null) {
            throw new IllegalStateException();
        }
        Object object = poolItem._shareLock;
        synchronized (object) {
            this._sharePoolItem = poolItem;
            this._sharePrev = null;
            this._shareNext = poolItem._shareHead;
            if (poolItem._shareHead != null) {
                poolItem._shareHead._sharePrev = this;
            }
            poolItem._shareHead = this;
        }
    }

    boolean isClosed() {
        return this._sharePoolItem == null;
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._cm.getName() + "," + this._id + "]";
    }
}

