/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.session;

import com.caucho.config.ConfigException;
import com.caucho.config.gen.BeanGenerator;
import com.caucho.config.gen.CandiUtil;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.reflect.BaseType;
import com.caucho.ejb.SessionPool;
import com.caucho.ejb.cfg.EjbLazyGenerator;
import com.caucho.ejb.gen.StatelessGenerator;
import com.caucho.ejb.inject.StatelessBeanImpl;
import com.caucho.ejb.manager.EjbManager;
import com.caucho.ejb.server.AbstractContext;
import com.caucho.ejb.server.EjbInjectionTarget;
import com.caucho.ejb.server.StatelessInjectionTarget;
import com.caucho.ejb.session.AbstractSessionContext;
import com.caucho.ejb.session.AbstractSessionManager;
import com.caucho.ejb.session.StatelessContext;
import com.caucho.ejb.session.StatelessPool;
import com.caucho.ejb.session.StatelessProviderProxy;
import com.caucho.ejb.session.StatelessProxyFactory;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.lang.reflect.Type;
import java.util.List;
import java.util.Set;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.Decorator;
import javax.enterprise.inject.spi.Interceptor;
import javax.enterprise.inject.spi.SessionBeanType;

public class StatelessManager<X>
extends AbstractSessionManager<X> {
    private static final L10N L = new L10N(StatelessManager.class);
    private static Logger log = Logger.getLogger(StatelessManager.class.getName());
    private int _sessionIdleMax = 16;
    private int _sessionConcurrentMax = -1;
    private long _sessionConcurrentTimeout = -1L;
    private ThreadLocal<StatelessPool<X, ?>> _localSessionPool = new ThreadLocal();
    private Object _decoratorClass;
    private List<Decorator<?>> _decoratorBeans;

    public StatelessManager(EjbManager ejbContainer, String ejbName, String moduleName, AnnotatedType<X> rawAnnType, AnnotatedType<X> annotatedType, EjbLazyGenerator<X> ejbGenerator) {
        super(ejbContainer, ejbName, moduleName, rawAnnType, annotatedType, ejbGenerator);
        this.introspect();
    }

    @Override
    protected String getType() {
        return "stateless:";
    }

    @Override
    protected SessionBeanType getSessionBeanType() {
        return SessionBeanType.STATELESS;
    }

    public int getSessionIdleMax() {
        return this._sessionIdleMax;
    }

    public int getSessionConcurrentMax() {
        return this._sessionConcurrentMax;
    }

    public long getSessionConcurrentTimeout() {
        return this._sessionConcurrentTimeout;
    }

    @Override
    protected <T> StatelessContext<X, T> getSessionContext(Class<T> api) {
        return (StatelessContext)super.getSessionContext(api);
    }

    @Override
    public <T> Object getLocalJndiProxy(Class<T> api) {
        AbstractSessionContext context = this.getSessionContext((Class)api);
        return new StatelessProviderProxy(context.createProxy(null));
    }

    @Override
    public <T> T getLocalProxy(Class<T> api) {
        return this.getSessionContext((Class)api).createProxy(null);
    }

    public void setLocalStatelessPool(StatelessPool<X, ?> pool) {
        this._localSessionPool.set(pool);
    }

    public StatelessPool<X, ?> getLocalStatelessPool() {
        return this._localSessionPool.get();
    }

    @Override
    protected <T> Bean<T> createBean(ManagedBeanImpl<X> mBean, Class<T> api, Set<Type> apiList, AnnotatedType<X> extAnnType) {
        AbstractSessionContext context = this.getSessionContext((Class)api);
        if (context == null) {
            throw new NullPointerException(L.l("'{0}' is an unknown api for {1}", api, (Object)this));
        }
        StatelessBeanImpl<X, T> statelessBean = new StatelessBeanImpl<X, T>(this, mBean, api, apiList, context, extAnnType);
        return statelessBean;
    }

    @Override
    protected Class<?> getContextClass() {
        return StatelessContext.class;
    }

    @Override
    protected BeanGenerator<X> createBeanGenerator() {
        EjbLazyGenerator lazyGen = this.getLazyGenerator();
        return new StatelessGenerator(this.getEJBName(), this.getAnnotatedType(), lazyGen.getLocalApi(), lazyGen.getLocalBean(), lazyGen.getRemoteApi());
    }

    public <T> StatelessPool<X, T> createStatelessPool(StatelessProxyFactory proxy, StatelessContext<X, T> context, List<Interceptor<?>> interceptorBeans) {
        return new StatelessPool<X, T>(this, proxy, context, interceptorBeans);
    }

    @Override
    protected EjbInjectionTarget<X> createInjectionTarget() {
        return new StatelessInjectionTarget(this, this.getAnnotatedType());
    }

    @Override
    public <T> T getRemoteObject(Class<T> api, String protocol) {
        if (api == null) {
            return null;
        }
        AbstractSessionContext context = this.getSessionContext((Class)api);
        if (context != null) {
            Object result = context.createProxy(null);
            return result;
        }
        log.fine(this + " unknown api " + api.getName());
        return null;
    }

    @Override
    public void init() throws Exception {
        super.init();
    }

    private void introspect() {
        AnnotatedType annType = this.getAnnotatedType();
        SessionPool sessionPool = (SessionPool)annType.getAnnotation(SessionPool.class);
        if (sessionPool != null) {
            if (sessionPool.maxIdle() >= 0) {
                this._sessionIdleMax = sessionPool.maxIdle();
            }
            if (sessionPool.maxConcurrent() >= 0) {
                this._sessionConcurrentMax = sessionPool.maxConcurrent();
            }
            if (sessionPool.maxConcurrentTimeout() >= 0L) {
                this._sessionConcurrentTimeout = sessionPool.maxConcurrentTimeout();
            }
        }
    }

    @Override
    protected <T> StatelessContext<X, T> createSessionContext(Class<T> api) {
        return new StatelessContext(this, api);
    }

    @Override
    protected void postStart() {
    }

    @Override
    public AbstractContext getContext(Object key, boolean forceLoad) {
        return this.getContext();
    }

    public Object[] getInterceptorBindings(List<Interceptor<?>> interceptorBeans, CreationalContextImpl<?> parentEnv) {
        int size = interceptorBeans.size();
        if (size == 0) {
            return null;
        }
        Object[] interceptors = new Object[size];
        for (int i = 0; i < size; ++i) {
            Interceptor<?> bean = interceptorBeans.get(i);
            interceptors[i] = this.getInjectManager().getReference(bean, parentEnv);
        }
        return interceptors;
    }

    @Override
    public void bind() {
        super.bind();
        Class<?> instanceClass = this.getProxyImplClass();
        if (instanceClass != null) {
            try {
                Method method = instanceClass.getMethod("__caucho_decorator_init", new Class[0]);
                this._decoratorClass = method.invoke(null, new Object[0]);
                Annotation[] qualifiers = new Annotation[this.getBean().getQualifiers().size()];
                this.getBean().getQualifiers().toArray(qualifiers);
                InjectManager moduleBeanManager = InjectManager.create();
                Class ejbClass = this.getAnnotatedType().getJavaClass();
                BaseType type = BaseType.createGenericClass((Class)ejbClass);
                Set types = type.getTypeClosure(moduleBeanManager);
                this._decoratorBeans = moduleBeanManager.resolveDecorators(types, new Annotation[0]);
                method = instanceClass.getMethod("__caucho_init_decorators", List.class);
                method.invoke(null, this._decoratorBeans);
            }
            catch (InvocationTargetException e) {
                throw ConfigException.create((Throwable)e.getCause());
            }
            catch (Exception e) {
                log.log(Level.FINEST, e.toString(), e);
            }
        }
    }

    Object[] createDelegates(CreationalContextImpl<?> env) {
        if (this._decoratorBeans != null) {
            return CandiUtil.generateProxyDelegate((InjectManager)this.getInjectManager(), this._decoratorBeans, (Object)this._decoratorClass, env);
        }
        return null;
    }
}

