/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.inject;

import com.caucho.config.ConfigException;
import com.caucho.config.event.EventManager;
import com.caucho.config.inject.CreationalContextImpl;
import com.caucho.config.inject.InjectEnvironmentBean;
import com.caucho.config.inject.InjectManager;
import com.caucho.config.inject.ManagedBeanImpl;
import com.caucho.config.inject.ScopeAdapterBean;
import com.caucho.config.reflect.AnnotatedMethodImpl;
import com.caucho.config.reflect.AnnotatedParameterImpl;
import com.caucho.config.reflect.AnnotatedTypeUtil;
import com.caucho.ejb.inject.EjbGeneratedBean;
import com.caucho.ejb.session.AbstractSessionContext;
import com.caucho.inject.Module;
import com.caucho.util.L10N;
import java.lang.annotation.Annotation;
import java.lang.reflect.Type;
import java.util.Collection;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.enterprise.context.spi.CreationalContext;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedParameter;
import javax.enterprise.inject.spi.AnnotatedType;
import javax.enterprise.inject.spi.Bean;
import javax.enterprise.inject.spi.InjectionPoint;
import javax.enterprise.inject.spi.PassivationCapable;

@Module
public class SessionBeanImpl<X, T>
implements ScopeAdapterBean<T>,
Bean<T>,
PassivationCapable,
EjbGeneratedBean,
InjectEnvironmentBean {
    private static final L10N L = new L10N(SessionBeanImpl.class);
    private AbstractSessionContext<X, T> _context;
    private ManagedBeanImpl<X> _bean;
    private LinkedHashSet<Type> _types = new LinkedHashSet();

    public SessionBeanImpl(AbstractSessionContext<X, T> context, ManagedBeanImpl<X> bean, Set<Type> apiList, AnnotatedType<X> extAnnType) {
        this._context = context;
        this._bean = bean;
        this._types.addAll(apiList);
        this.introspectObservers(bean.getAnnotatedType(), extAnnType);
    }

    public InjectManager getCdiManager() {
        return this._context.getInjectManager();
    }

    protected ManagedBeanImpl<X> getBean() {
        return this._bean;
    }

    public Set<Type> getTypes() {
        return this._types;
    }

    public T getScopeAdapter(Bean<?> topBean, CreationalContextImpl<T> context) {
        return null;
    }

    public T create(CreationalContext<T> env) {
        T value = env instanceof CreationalContextImpl ? this._context.createProxy((CreationalContextImpl)env) : this._context.createProxy(null);
        if (env != null) {
            env.push(value);
        }
        return value;
    }

    public void destroy(T instance, CreationalContext<T> cxt) {
        CreationalContextImpl env = cxt instanceof CreationalContextImpl ? (CreationalContextImpl)cxt : null;
        if (env != null) {
            env.release();
        } else {
            this._context.destroyProxy(instance, env);
        }
    }

    public Set<InjectionPoint> getInjectionPoints() {
        return this.getBean().getInjectionPoints();
    }

    public Class<?> getBeanClass() {
        return this.getBean().getBeanClass();
    }

    public String getName() {
        return this.getBean().getName();
    }

    public Set<Annotation> getQualifiers() {
        return this.getBean().getQualifiers();
    }

    public Class<? extends Annotation> getScope() {
        return this.getBean().getScope();
    }

    public Set<Class<? extends Annotation>> getStereotypes() {
        return this.getBean().getStereotypes();
    }

    public boolean isAlternative() {
        return this.getBean().isAlternative();
    }

    public boolean isNullable() {
        return false;
    }

    public String getId() {
        return this.getBean().getId();
    }

    private void introspectObservers(AnnotatedType<X> beanType, AnnotatedType<X> extAnnType) {
        EventManager eventManager = this._context.getModuleInjectManager().getEventManager();
        for (AnnotatedMethod beanMethod : beanType.getMethods()) {
            int param;
            AnnotatedMethod apiMethod = AnnotatedTypeUtil.findMethod(extAnnType, (AnnotatedMethod)beanMethod);
            boolean isBeanMethod = false;
            if (apiMethod == null) {
                apiMethod = beanMethod;
                isBeanMethod = true;
            } else if (apiMethod instanceof AnnotatedMethodImpl) {
                AnnotatedMethodImpl apiMethodImpl = (AnnotatedMethodImpl)apiMethod;
                apiMethodImpl.addAnnotations((Collection)beanMethod.getAnnotations());
                for (int i = 0; i < apiMethod.getParameters().size(); ++i) {
                    AnnotatedParameterImpl paramImpl = (AnnotatedParameterImpl)apiMethod.getParameters().get(i);
                    AnnotatedParameter beanParam = (AnnotatedParameter)beanMethod.getParameters().get(i);
                    paramImpl.addAnnotations((Collection)beanParam.getAnnotations());
                }
            }
            if ((param = EventManager.findObserverAnnotation((AnnotatedMethod)apiMethod)) < 0) continue;
            if (isBeanMethod && !apiMethod.isStatic() && !this._types.contains(beanType.getJavaClass())) {
                throw new ConfigException(L.l("{0}.{1} is an invalid @Observes method because @Observes must be in the @Local API.", (Object)beanMethod.getDeclaringType().getJavaClass().getSimpleName(), (Object)beanMethod.getJavaMember().getName()));
            }
            eventManager.addObserver((Bean)this, apiMethod);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getBeanClass().getSimpleName() + ", " + this.getQualifiers() + "]";
    }
}

