/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.gen;

import com.caucho.config.gen.AspectBeanFactory;
import com.caucho.config.gen.AspectFactory;
import com.caucho.config.gen.MethodTailGenerator;
import com.caucho.ejb.gen.StatelessMethodTailFactory;
import com.caucho.inject.Module;
import com.caucho.java.JavaWriter;
import java.io.IOException;
import javax.enterprise.inject.spi.AnnotatedMethod;
import javax.enterprise.inject.spi.AnnotatedType;

@Module
public class StatelessMethodTailGenerator<X>
extends MethodTailGenerator<X> {
    public StatelessMethodTailGenerator(StatelessMethodTailFactory<X> factory, AnnotatedMethod<? super X> method) {
        super(factory, method);
    }

    public void generatePreTry(JavaWriter out) throws IOException {
        out.println("Thread thread = Thread.currentThread();");
        out.println("ClassLoader oldLoader = thread.getContextClassLoader();");
        out.println("thread.setContextClassLoader(_manager.getClassLoader());");
        super.generatePreTry(out);
        out.println();
        out.println("boolean isValid = false;");
        out.println("StatelessPool.Item<" + this.getJavaClass().getName() + "> poolItem");
        out.println("  = _statelessPool.allocate();");
        out.println(this.getJavaClass().getName() + " bean = poolItem.getValue();");
    }

    protected AspectFactory<X> getFactory() {
        return this._factory;
    }

    protected AspectBeanFactory<X> getBeanFactory() {
        return this._factory.getAspectBeanFactory();
    }

    protected AnnotatedType<X> getBeanType() {
        return this._factory.getBeanType();
    }

    protected Class<X> getJavaClass() {
        return this.getBeanType().getJavaClass();
    }

    public void generatePreCall(JavaWriter out) throws IOException {
        out.println("thread.setContextClassLoader(_manager.getClassLoader());");
        super.generatePreCall(out);
    }

    public void generatePostCall(JavaWriter out) throws IOException {
        super.generatePostCall(out);
        out.println();
        out.println("isValid = true;");
    }

    public void generateApplicationException(JavaWriter out, Class<?> exn) throws IOException {
        out.println("isValid = true;");
        super.generateApplicationException(out, exn);
    }

    public void generateFinally(JavaWriter out) throws IOException {
        out.println("if (isValid)");
        out.println("  _statelessPool.free(poolItem);");
        out.println("else");
        out.println("  _statelessPool.discard(poolItem);");
        super.generateFinally(out);
        out.println();
        out.println("thread.setContextClassLoader(oldLoader);");
    }
}

