/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.ejb.cfg;

import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.TagName;
import com.caucho.util.L10N;
import javax.jms.Destination;
import javax.jms.Queue;
import javax.jms.Topic;

@Configurable
public class JmsActivationConfig {
    private static final L10N L = new L10N(JmsActivationConfig.class);
    private String _connectionFactoryName;
    private Class<?> _destinationType = Queue.class;
    private String _destinationName;
    private Destination _destinationObject;
    private int _maxPoolSize = 1;

    @Configurable
    @TagName(value={"ConnectionFactoryJndiName", "connectionFactoryJndiName"})
    public void setConnectionFactoryJndiName(String jndiName) {
        this._connectionFactoryName = jndiName;
    }

    @Configurable
    @TagName(value={"ConnectionFactoryName", "connectionFactoryName"})
    public void setConnectionFactoryName(String name) {
        this._connectionFactoryName = name;
    }

    public String getConnectionFactoryName() {
        return this._connectionFactoryName;
    }

    public String getDestinationName() {
        return this._destinationName;
    }

    @Configurable
    @TagName(value={"DestinationJndiName", "destinationJndiName"})
    public void setDestinationJndiName(String jndiName) {
        this._destinationName = jndiName;
    }

    @Configurable
    @TagName(value={"DestinationName", "destinationName"})
    public void setDestinationName(String jndiName) {
        this.setDestinationJndiName(jndiName);
    }

    @Configurable
    @TagName(value={"DestinationType", "destinationType"})
    public void setDestinationType(Class<?> type) {
        if (!Queue.class.equals(type) && !Topic.class.equals(type)) {
            throw new ConfigException(L.l("JMS DestinationType must be javax.jms.Queue or javax.jms.Topic"));
        }
        this._destinationType = type;
    }

    public Class<? extends Destination> getDestinationType() {
        return this._destinationType;
    }

    public Destination getDestinationObject() {
        return this._destinationObject;
    }

    public void setDestinationObject(Destination destination) {
        this._destinationObject = destination;
    }

    @Configurable
    @TagName(value={"MaxPoolSize", "maxPoolSize", "consumer-max", "message-consumer-max"})
    public void setMaxPoolSize(int poolSize) {
        this._maxPoolSize = poolSize;
    }

    public int getMaxPoolSize() {
        return this._maxPoolSize;
    }
}

