/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.xa;

import com.caucho.db.blob.Inode;
import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.db.lock.DatabaseLock;
import com.caucho.db.xa.StoreTransaction;
import com.caucho.util.L10N;
import com.caucho.util.SQLExceptionWrapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DbTransaction
extends StoreTransaction {
    private static final Logger log = Logger.getLogger(DbTransaction.class.getName());
    private static final L10N L = new L10N(DbTransaction.class);
    private static long AUTO_COMMIT_TIMEOUT = 30000L;
    private boolean _isAutoCommit = true;
    private ConnectionImpl _conn;
    private ArrayList<DatabaseLock> _readLocks;
    private ArrayList<DatabaseLock> _writeLocks;
    private ArrayList<Block> _updateBlocks;
    private ArrayList<Inode> _deleteInodes;
    private ArrayList<Inode> _addInodes;
    private ArrayList<Block> _deallocateBlocks;
    private boolean _isRollbackOnly;
    private SQLException _rollbackExn;
    private long _timeout = AUTO_COMMIT_TIMEOUT;

    private DbTransaction() {
    }

    public static DbTransaction create(ConnectionImpl conn) {
        DbTransaction xa = new DbTransaction();
        xa.init(conn);
        return xa;
    }

    public static DbTransaction create() {
        DbTransaction xa = new DbTransaction();
        return xa;
    }

    private void init(ConnectionImpl conn) {
        this._conn = conn;
        this._timeout = AUTO_COMMIT_TIMEOUT;
        this._isRollbackOnly = false;
        this._rollbackExn = null;
    }

    public void setTimeout(long timeout) {
        this._timeout = timeout;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public boolean hasReadLock(DatabaseLock lock) {
        return this._readLocks.contains(lock);
    }

    public boolean isAutoCommit() {
        return this._isAutoCommit;
    }

    public void setAutoCommit(boolean autoCommit) {
        this._isAutoCommit = autoCommit;
    }

    public void lockRead(DatabaseLock lock) throws SQLException {
        if (this._isRollbackOnly) {
            if (this._rollbackExn != null) {
                throw this._rollbackExn;
            }
            throw new SQLException(L.l("can't get lock with rollback transaction"));
        }
        try {
            if (this._readLocks == null) {
                this._readLocks = new ArrayList();
            }
            if (this._readLocks.contains(lock)) {
                throw new SQLException(L.l("lockRead must not already have a read lock"));
            }
            lock.lockRead(this._timeout);
            this._readLocks.add(lock);
        }
        catch (SQLException e) {
            this.setRollbackOnly(e);
            throw e;
        }
    }

    public void lockReadAndWrite(DatabaseLock lock) throws SQLException {
        if (this._isRollbackOnly) {
            if (this._rollbackExn != null) {
                throw this._rollbackExn;
            }
            throw new SQLException(L.l("can't get lock with rollback transaction"));
        }
        try {
            if (this._readLocks == null) {
                this._readLocks = new ArrayList();
            }
            if (this._writeLocks == null) {
                this._writeLocks = new ArrayList();
            }
            if (this._readLocks.contains(lock)) {
                throw new SQLException(L.l("lockReadAndWrite cannot already have a read lock"));
            }
            if (this._writeLocks.contains(lock)) {
                throw new SQLException(L.l("lockReadAndWrite cannot already have a write lock"));
            }
            lock.lockWrite(this._timeout);
            this._readLocks.add(lock);
            this._writeLocks.add(lock);
        }
        catch (SQLException e) {
            this.setRollbackOnly(e);
            throw e;
        }
    }

    public boolean lockReadAndWriteNoWait(DatabaseLock lock) throws SQLException {
        if (this._isRollbackOnly) {
            if (this._rollbackExn != null) {
                throw this._rollbackExn;
            }
            throw new SQLException(L.l("can't get lock with rollback transaction"));
        }
        try {
            if (this._readLocks == null) {
                this._readLocks = new ArrayList();
            }
            if (this._writeLocks == null) {
                this._writeLocks = new ArrayList();
            }
            if (this._readLocks.contains(lock)) {
                throw new SQLException(L.l("lockReadAndWrite cannot already have a read lock"));
            }
            if (this._writeLocks.contains(lock)) {
                throw new SQLException(L.l("lockReadAndWrite cannot already have a write lock"));
            }
        }
        catch (SQLException e) {
            this.setRollbackOnly(e);
            throw e;
        }
        return false;
    }

    @Override
    public void addUpdateBlock(Block block) {
        if (block == null) {
            return;
        }
        if (this._updateBlocks == null) {
            this._updateBlocks = new ArrayList();
        }
        if (this._updateBlocks.size() == 0 || this._updateBlocks.get(this._updateBlocks.size() - 1) != block) {
            this._updateBlocks.add(block);
        }
    }

    public void autoCommitRead(DatabaseLock lock) throws SQLException {
        this.unlockRead(lock);
    }

    public void unlockRead(DatabaseLock lock) throws SQLException {
        if (this._readLocks.remove(lock)) {
            lock.unlockRead();
        }
    }

    public void autoCommitWrite(DatabaseLock lock) throws SQLException {
        this._readLocks.remove(lock);
        if (this._writeLocks.remove(lock)) {
            try {
                this.commit();
            }
            finally {
                lock.unlockWrite();
            }
        }
    }

    public void unlockReadAndWrite(DatabaseLock lock) throws SQLException {
        this._readLocks.remove(lock);
        if (this._writeLocks.remove(lock)) {
            lock.unlockWrite();
        }
    }

    @Override
    public Block readBlock(BlockStore store, long blockAddress) throws IOException {
        long blockId = store.addressToBlockId(blockAddress);
        Block block = null;
        if (block != null) {
            block.allocate();
        } else {
            block = store.readBlock(blockId);
        }
        return block;
    }

    public Block loadBlock(BlockStore store, long blockAddress) throws IOException {
        long blockId = store.addressToBlockId(blockAddress);
        Block block = store.loadBlock(blockId);
        return block;
    }

    public Block allocateRow(BlockStore store) throws IOException {
        return store.allocateRow();
    }

    public void deallocateBlock(Block block) throws IOException {
        if (this.isAutoCommit()) {
            block.getStore().deallocateBlock(block.getBlockId());
        } else {
            if (this._deallocateBlocks == null) {
                this._deallocateBlocks = new ArrayList();
            }
            this._deallocateBlocks.add(block);
        }
    }

    public void addDeleteInode(Inode inode) {
        if (this._deleteInodes == null) {
            this._deleteInodes = new ArrayList();
        }
        this._deleteInodes.add(inode);
    }

    public void addAddInode(Inode inode) {
        if (this._addInodes == null) {
            this._addInodes = new ArrayList();
        }
        this._addInodes.add(inode);
    }

    public void autoCommit() throws SQLException {
        if (this._isAutoCommit) {
            ConnectionImpl conn = this._conn;
            this._conn = null;
            if (conn != null) {
                conn.setTransaction(null);
            }
        }
    }

    public void setRollbackOnly(SQLException e) {
        if (this._rollbackExn == null) {
            this._rollbackExn = e;
        }
        this._isRollbackOnly = true;
        this.releaseLocks();
    }

    public void setRollbackOnly() {
        this.setRollbackOnly(null);
    }

    public void commit() throws SQLException {
        try {
            this.writeData();
        }
        finally {
            this.releaseLocks();
            this.close();
        }
    }

    public void writeData() throws SQLException {
        Block block;
        ArrayList<Block> updateBlocks = this._updateBlocks;
        if (updateBlocks != null) {
            while (updateBlocks.size() > 0) {
                block = updateBlocks.remove(updateBlocks.size() - 1);
                try {
                    block.getStore().saveAllocation();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
                try {
                    block.commitNoWake();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        if (this._deleteInodes != null) {
            while (this._deleteInodes.size() > 0) {
                Inode inode = this._deleteInodes.remove(0);
                try {
                    inode.remove();
                }
                catch (Exception e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
        }
        if (this._deallocateBlocks != null) {
            while (this._deallocateBlocks.size() > 0) {
                block = this._deallocateBlocks.remove(0);
                try {
                    block.getStore().deallocateBlock(block.getBlockId());
                }
                catch (IOException e) {
                    throw new SQLExceptionWrapper((Throwable)e);
                }
            }
        }
    }

    public void rollback() throws SQLException {
        this.releaseLocks();
        this.close();
    }

    private void releaseLocks() {
        DatabaseLock lock;
        int i;
        if (this._writeLocks != null) {
            for (i = 0; i < this._writeLocks.size(); ++i) {
                lock = this._writeLocks.get(i);
                if (this._readLocks != null) {
                    this._readLocks.remove(lock);
                }
                try {
                    lock.unlockWrite();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            this._writeLocks.clear();
        }
        if (this._readLocks != null) {
            for (i = 0; i < this._readLocks.size(); ++i) {
                lock = this._readLocks.get(i);
                try {
                    lock.unlockRead();
                    continue;
                }
                catch (Throwable e) {
                    log.log(Level.WARNING, e.toString(), e);
                }
            }
            this._readLocks.clear();
        }
    }

    void close() {
        this._isRollbackOnly = false;
        this._rollbackExn = null;
    }
}

