/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.table;

import com.caucho.db.index.BTree;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.table.Column;
import com.caucho.db.table.Constraint;
import com.caucho.db.table.Table;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.DbTransaction;
import com.caucho.util.L10N;
import com.caucho.util.SQLExceptionWrapper;
import java.io.IOException;
import java.sql.SQLException;

public class UniqueSingleColumnConstraint
extends Constraint {
    private static final L10N L = new L10N(UniqueSingleColumnConstraint.class);
    private final Column _uniqueColumn;

    public UniqueSingleColumnConstraint(Column column) {
        this._uniqueColumn = column;
    }

    @Override
    public void validate(TableIterator[] sourceRows, QueryContext queryContext, DbTransaction xa) throws SQLException {
        Column column = this._uniqueColumn;
        BTree index = column.getIndex();
        if (index != null) {
            this.validateIndex(sourceRows, queryContext, xa);
            return;
        }
        TableIterator sourceRow = sourceRows[0];
        Table table = sourceRow.getTable();
        TableIterator iter = table.createTableIterator();
        try {
            byte[] sourceBuffer = sourceRow.getBuffer();
            int sourceOffset = sourceRow.getRowOffset();
            iter.init(queryContext);
            while (iter.next()) {
                byte[] iterBuffer = iter.getBuffer();
                iter.prevRow();
                while (iter.nextRow()) {
                    int iterOffset = iter.getRowOffset();
                    if (iterBuffer == sourceBuffer && iterOffset == sourceOffset || !column.isEqual(iterBuffer, iterOffset, sourceBuffer, sourceOffset)) continue;
                    long blockId = iter.getBlockId();
                    throw new SQLException(L.l("`{0}' in {1}.{2} fails uniqueness constraint.", (Object)column.getString(blockId, iterBuffer, iterOffset), (Object)table.getName(), (Object)column.getName()));
                }
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper((Throwable)e);
        }
        finally {
            iter.free();
        }
    }

    private void validateIndex(TableIterator[] sourceRows, QueryContext context, DbTransaction xa) throws SQLException {
        try {
            Column column = this._uniqueColumn;
            TableIterator sourceRow = sourceRows[0];
            byte[] sourceBuffer = sourceRow.getBuffer();
            int sourceOffset = sourceRow.getRowOffset();
            BTree index = column.getIndex();
            int length = column.getLength();
            int offset = sourceOffset + this._uniqueColumn.getColumnOffset();
            long value = index.lookup(sourceBuffer, offset, length);
            if (value != 0L) {
                Table table = sourceRow.getTable();
                long blockId = sourceRow.getBlockId();
                throw new SQLException(L.l("'{0}' in {1}.{2} fails uniqueness constraint with block address {3}.", (Object)column.getString(blockId, sourceBuffer, sourceOffset), (Object)table.getName(), (Object)column.getName(), (Object)("" + value / 8192L + "." + value % 8192L)));
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper((Throwable)e);
        }
    }
}

