/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.blob.BlobInputStream;
import com.caucho.db.block.BlockStore;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.ResultSetImpl;
import com.caucho.db.table.Column;
import com.caucho.db.table.TableIterator;
import com.caucho.util.CharBuffer;
import com.caucho.util.FreeList;
import com.caucho.util.L10N;
import com.caucho.util.QDate;
import com.caucho.util.SQLExceptionWrapper;
import com.caucho.vfs.ReadStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.TempBuffer;
import com.caucho.vfs.TempStream;
import com.caucho.vfs.WriteStream;
import java.io.IOException;
import java.sql.SQLException;

public class SelectResultSetImpl
extends ResultSetImpl {
    private static final L10N L = new L10N(SelectResultSetImpl.class);
    private static final FreeList<SelectResultSetImpl> _freeList = new FreeList(16);
    private final WriteStream _ws;
    private final TempBuffer _buf;
    private final ReadStream _rs;
    private final byte[] _buffer;
    private final CharBuffer _cb;
    private final TempStream _ts;
    private static QDate _date = new QDate();
    private Expr[] _exprs;
    private Column.ColumnType[] _types = new Column.ColumnType[32];
    private int[] _offsets = new int[32];
    private int[] _lengths = new int[32];
    private BlockStore[] _stores = new BlockStore[32];
    private TableIterator[] _rows;
    private int _lastColumn;

    private SelectResultSetImpl() {
        this._ws = new WriteStream();
        this._ws.setReuseBuffer(true);
        this._ts = new TempStream();
        this._rs = new ReadStream();
        this._rs.setReuseBuffer(true);
        this._buf = TempBuffer.allocate();
        this._buffer = this._buf.getBuffer();
        this._cb = new CharBuffer();
        this._rows = new TableIterator[0];
    }

    public static SelectResultSetImpl create(Expr[] exprs) {
        SelectResultSetImpl rs = (SelectResultSetImpl)_freeList.allocate();
        if (rs == null) {
            rs = new SelectResultSetImpl();
        }
        rs.init(exprs);
        return rs;
    }

    TableIterator[] initRows(FromItem[] fromItems) {
        if (this._rows.length < fromItems.length) {
            this._rows = new TableIterator[fromItems.length];
        }
        for (int i = 0; i < fromItems.length; ++i) {
            if (this._rows[i] == null) {
                this._rows[i] = new TableIterator();
            }
            this._rows[i].init(fromItems[i].getTable());
        }
        return this._rows;
    }

    private void init(Expr[] exprs) {
        this._exprs = exprs;
        if (this._offsets.length < this._exprs.length) {
            this._offsets = new int[exprs.length];
            this._lengths = new int[exprs.length];
            this._types = new Column.ColumnType[exprs.length];
            this._stores = new BlockStore[exprs.length];
        }
        for (int i = 0; i < exprs.length; ++i) {
            this._stores[i] = exprs[i].getTable();
        }
    }

    void initRead() throws IOException {
        this._ts.openRead(this._rs);
    }

    WriteStream getWriteStream() {
        this._ts.openWrite();
        this._ws.init((StreamImpl)this._ts);
        return this._ws;
    }

    @Override
    public boolean next() throws SQLException {
        try {
            ReadStream rs = this._rs;
            this._lastColumn = 0;
            int hasData = rs.read();
            if (hasData <= 0) {
                return false;
            }
            int length = 0;
            int fields = this._exprs.length;
            byte[] buffer = this._buffer;
            for (int i = 0; i < fields; ++i) {
                int type = rs.read();
                int sublen = 0;
                if (type < 0) {
                    return false;
                }
                Column.ColumnType cType = Column.ColumnType.values()[type];
                switch (cType) {
                    case NONE: {
                        sublen = -1;
                        break;
                    }
                    case VARCHAR: {
                        int l0 = rs.read();
                        int l1 = rs.read();
                        int l2 = rs.read();
                        int l3 = rs.read();
                        sublen = (l0 << 24) + (l1 << 16) + (l2 << 8) + l3;
                        break;
                    }
                    case INT: {
                        sublen = 4;
                        break;
                    }
                    case LONG: 
                    case DOUBLE: 
                    case DATE: {
                        sublen = 8;
                        break;
                    }
                    case BLOB: {
                        sublen = 128;
                        break;
                    }
                    default: {
                        throw new SQLException("Unknown column: " + type);
                    }
                }
                this._types[i] = cType;
                this._offsets[i] = length;
                this._lengths[i] = sublen;
                if (sublen <= 0) continue;
                rs.read(buffer, length, sublen);
                length += sublen;
            }
            return true;
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper((Throwable)e);
        }
    }

    @Override
    public int findColumnIndex(String name) throws SQLException {
        for (int i = 0; i < this._exprs.length; ++i) {
            if (!this._exprs[i].getName().equals(name)) continue;
            return i + 1;
        }
        throw new SQLException(L.l("column `{0}' does not exist.", (Object)name));
    }

    @Override
    public String getString(int index) throws SQLException {
        this._lastColumn = index;
        byte[] buffer = this._buffer;
        int offset = this._offsets[index];
        int length = this._lengths[index];
        switch (this._types[index]) {
            case NONE: {
                return null;
            }
            case INT: {
                int value = ((buffer[offset] & 0xFF) << 24) + ((buffer[offset + 1] & 0xFF) << 16) + ((buffer[offset + 2] & 0xFF) << 8) + (buffer[offset + 3] & 0xFF);
                return String.valueOf(value);
            }
            case LONG: {
                long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
                return String.valueOf(value);
            }
            case DOUBLE: {
                long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
                return String.valueOf(Double.longBitsToDouble(value));
            }
            case DATE: {
                long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
                return QDate.formatGMT((long)value);
            }
            case VARCHAR: {
                return this.getStringValue(index);
            }
            case BLOB: {
                return this.getBlobString(index);
            }
        }
        return null;
    }

    private String getStringValue(int index) throws SQLException {
        int length;
        this._lastColumn = index;
        int offset = this._offsets[index];
        if (length < 0) {
            return null;
        }
        CharBuffer cb = this._cb;
        cb.clear();
        byte[] buffer = this._buffer;
        for (length = this._lengths[index]; length > 0; --length) {
            cb.append((char)buffer[offset++]);
        }
        return cb.toString();
    }

    private String getBlobString(int index) throws SQLException {
        this._lastColumn = index;
        int offset = this._offsets[index];
        CharBuffer cb = this._cb;
        cb.clear();
        BlobInputStream is = null;
        try {
            int ch;
            is = new BlobInputStream(this._stores[index], this._buffer, offset);
            while ((ch = is.read()) >= 0) {
                if (ch >= 128) continue;
                cb.append((char)ch);
            }
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper((Throwable)e);
        }
        return cb.toString();
    }

    @Override
    public int getInt(int index) throws SQLException {
        this._lastColumn = index;
        byte[] buffer = this._buffer;
        int offset = this._offsets[index];
        int length = this._lengths[index];
        switch (this._types[index]) {
            case NONE: {
                return 0;
            }
            case INT: {
                return ((buffer[offset + 0] & 0xFF) << 24) + ((buffer[offset + 1] & 0xFF) << 16) + ((buffer[offset + 2] & 0xFF) << 8) + (buffer[offset + 3] & 0xFF);
            }
            case LONG: {
                long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
                return (int)value;
            }
            case DOUBLE: {
                long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
                return (int)Double.longBitsToDouble(value);
            }
            case VARCHAR: {
                return Integer.parseInt(this.getString(index));
            }
        }
        return 0;
    }

    @Override
    public long getLong(int index) throws SQLException {
        this._lastColumn = index;
        byte[] buffer = this._buffer;
        int offset = this._offsets[index];
        int length = this._lengths[index];
        switch (this._types[index]) {
            case NONE: {
                return 0L;
            }
            case INT: {
                return ((buffer[offset] & 0xFF) << 24) + ((buffer[offset + 1] & 0xFF) << 16) + ((buffer[offset + 2] & 0xFF) << 8) + (buffer[offset + 3] & 0xFF);
            }
            case LONG: 
            case DATE: {
                long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
                return value;
            }
            case DOUBLE: {
                long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
                return (long)Double.longBitsToDouble(value);
            }
            case VARCHAR: {
                return Long.parseLong(this.getString(index));
            }
        }
        return 0L;
    }

    @Override
    public double getDouble(int index) throws SQLException {
        this._lastColumn = index;
        byte[] buffer = this._buffer;
        int offset = this._offsets[index];
        int length = this._lengths[index];
        switch (this._types[index]) {
            case NONE: {
                return 0.0;
            }
            case INT: {
                return ((buffer[offset + 0] & 0xFF) << 24) + ((buffer[offset + 1] & 0xFF) << 16) + ((buffer[offset + 2] & 0xFF) << 8) + (buffer[offset + 3] & 0xFF);
            }
            case LONG: {
                long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
                return value;
            }
            case DOUBLE: {
                long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
                return Double.longBitsToDouble(value);
            }
            case VARCHAR: {
                return Double.parseDouble(this.getString(index));
            }
        }
        return 0.0;
    }

    @Override
    public long getDate(int index) throws SQLException {
        this._lastColumn = index;
        byte[] buffer = this._buffer;
        int offset = this._offsets[index];
        int length = this._lengths[index];
        switch (this._types[index]) {
            case NONE: {
                return 0L;
            }
            case LONG: 
            case DATE: {
                long value = (((long)buffer[offset + 0] & 0xFFL) << 56) + (((long)buffer[offset + 1] & 0xFFL) << 48) + (((long)buffer[offset + 2] & 0xFFL) << 40) + (((long)buffer[offset + 3] & 0xFFL) << 32) + (((long)buffer[offset + 4] & 0xFFL) << 24) + (((long)buffer[offset + 5] & 0xFFL) << 16) + (((long)buffer[offset + 6] & 0xFFL) << 8) + ((long)buffer[offset + 7] & 0xFFL);
                return value;
            }
            case VARCHAR: 
            case BLOB: {
                String value = this.getString(index);
                if (value == null) {
                    return 0L;
                }
                QDate qDate = _date;
                synchronized (qDate) {
                    try {
                        return _date.parseDate(value);
                    }
                    catch (Exception e) {
                        throw new SQLExceptionWrapper((Throwable)e);
                    }
                }
            }
        }
        throw new SQLException("unknown type:" + (Object)((Object)this._types[index]));
    }

    @Override
    public boolean wasNull() {
        if (this._lastColumn < 0) {
            return false;
        }
        return this._lengths[this._lastColumn] < 0;
    }

    @Override
    public void close() {
        _freeList.free((Object)this);
    }
}

