/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.sql;

import com.caucho.db.Database;
import com.caucho.db.sql.Expr;
import com.caucho.db.sql.FromItem;
import com.caucho.db.sql.GroupExpr;
import com.caucho.db.sql.GroupItem;
import com.caucho.db.sql.GroupResultExpr;
import com.caucho.db.sql.Order;
import com.caucho.db.sql.Query;
import com.caucho.db.sql.QueryContext;
import com.caucho.db.sql.SelectCursor;
import com.caucho.db.sql.SelectResult;
import com.caucho.db.table.TableIterator;
import com.caucho.db.xa.DbTransaction;
import com.caucho.env.shutdown.ExitCode;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.util.CharBuffer;
import com.caucho.util.L10N;
import com.caucho.util.SQLExceptionWrapper;
import java.io.IOException;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;

public class SelectQuery
extends Query {
    private static final L10N L = new L10N(SelectQuery.class);
    private static final Logger log = Logger.getLogger(SelectQuery.class.getName());
    private Expr[] _results;
    private String[] _resultNames;
    private boolean[] _groupFields;
    private Order _order;
    private int _limit = 0x3FFFFFFF;

    SelectQuery(Database db, String sql) throws SQLException {
        super(db, sql);
    }

    SelectQuery(Database db, String sql, FromItem[] fromItems) throws SQLException {
        super(db, sql, fromItems);
    }

    void setResults(Expr[] resultExprs) throws SQLException {
        this._results = new Expr[resultExprs.length];
        for (int i = 0; i < resultExprs.length; ++i) {
            this._results[i] = resultExprs[i];
        }
        this.setDataFields(resultExprs.length);
    }

    Expr[] getResults() {
        return this._results;
    }

    public void setGroupResult(int index) {
        if (this._groupFields == null) {
            this._groupFields = new boolean[this._results.length];
        }
        this._groupFields[index] = true;
    }

    @Override
    protected void bind() throws SQLException {
        int i;
        super.bind();
        for (i = 0; i < this._results.length; ++i) {
            this._results[i] = this._results[i].bind(this);
        }
        if (this.isGroup()) {
            for (i = 0; i < this._results.length; ++i) {
                if (!this.isGroup() || this._results[i] instanceof GroupExpr) continue;
                this._results[i] = new GroupResultExpr(i, this._results[i]);
            }
        }
        for (i = 0; i < this._results.length; ++i) {
            this._results[i] = this._results[i].bind(this);
        }
        this._resultNames = new String[this._results.length];
        for (i = 0; i < this._resultNames.length; ++i) {
            this._resultNames[i] = this._results[i].getName();
        }
    }

    void setOrder(Order order) {
        this._order = order;
    }

    @Override
    public void setLimit(int limit) {
        this._limit = limit;
    }

    @Override
    public boolean isSelect() {
        return true;
    }

    Class<?> getType() {
        if (this._results.length == 1) {
            return this._results[0].getType();
        }
        return Object.class;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(QueryContext context, DbTransaction xa) throws SQLException {
        SelectResult result = SelectResult.create(this._results, this._order);
        FromItem[] fromItems = this.getFromItems();
        TableIterator[] rows = null;
        try {
            rows = result.initRows(fromItems);
            context.init(xa, rows, this.isReadOnly());
            if (this.isGroup()) {
                this.executeGroup(result, rows, context, xa);
            } else {
                this.execute(result, rows, context, xa);
            }
            result.initRead();
            context.setResult(result);
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper((Throwable)e);
        }
        catch (IllegalStateException exn) {
            log.log(Level.WARNING, exn.toString(), exn);
            ShutdownSystem.shutdownActive((ExitCode)ExitCode.HEALTH, (String)L.l("Internal database issue: forcing restart {0}", (Object)exn.toString()));
        }
        finally {
            try {
                context.close();
            }
            catch (Exception e) {
                log.log(Level.WARNING, e.toString(), e);
            }
            if (rows != null) {
                this.freeRows(rows, rows.length);
            }
        }
    }

    private void execute(SelectResult result, TableIterator[] rows, QueryContext context, DbTransaction xa) throws SQLException, IOException {
        FromItem[] fromItems = this.getFromItems();
        int rowLength = fromItems.length;
        int limit = this._limit;
        int contextLimit = context.getLimit();
        if (contextLimit > 0) {
            limit = contextLimit;
        }
        if (this.start(rows, rowLength, context, xa)) {
            do {
                result.startRow();
                for (int i = 0; i < this._results.length; ++i) {
                    this._results[i].evalToResult(context, result);
                }
            } while (this.nextTuple(rows, rowLength, context, xa) && --limit > 0);
        }
    }

    private void executeGroup(SelectResult result, TableIterator[] rows, QueryContext context, DbTransaction transaction) throws SQLException, IOException {
        FromItem[] fromItems = this.getFromItems();
        int rowLength = fromItems.length;
        Expr[] results = this._results;
        int resultsLength = results.length;
        if (this._groupFields == null) {
            this._groupFields = new boolean[0];
        }
        boolean[] groupByFields = this._groupFields;
        int groupByLength = this._groupFields.length;
        if (this.start(rows, rowLength, context, transaction)) {
            do {
                int i;
                context.initGroup(this.getDataFields(), this._groupFields);
                for (i = 0; i < groupByLength; ++i) {
                    if (!groupByFields[i]) continue;
                    results[i].evalGroup(context);
                }
                context.selectGroup();
                for (i = 0; i < resultsLength; ++i) {
                    if (i < groupByLength && groupByFields[i]) continue;
                    results[i].evalGroup(context);
                }
            } while (this.nextTuple(rows, rowLength, context, transaction));
        }
        Iterator<GroupItem> groupIter = context.groupResults();
        while (groupIter.hasNext()) {
            GroupItem item = groupIter.next();
            context.setGroupItem(item);
            result.startRow();
            for (int i = 0; i < results.length; ++i) {
                results[i].evalToResult(context, result);
            }
        }
    }

    @Override
    public SelectCursor executeCursor(QueryContext context, DbTransaction xa) throws SQLException {
        if (this.isGroup()) {
            throw new IllegalStateException();
        }
        if (this._order != null) {
            throw new IllegalStateException();
        }
        FromItem[] fromItems = this.getFromItems();
        TableIterator[] rows = null;
        SelectCursor cursor = new SelectCursor(this._results, this, context);
        rows = cursor.initRows(fromItems);
        context.init(xa, rows, this.isReadOnly());
        int rowLength = fromItems.length;
        if (this.start(rows, rowLength, context, xa)) {
            context.unlock();
            return cursor;
        }
        return null;
    }

    public final boolean nextCursor(TableIterator[] rows, QueryContext context, DbTransaction xa) throws SQLException {
        try {
            FromItem[] fromItems = this.getFromItems();
            int rowLength = fromItems.length;
            boolean value = this.nextTuple(rows, rowLength, context, xa);
            return value;
        }
        catch (IOException e) {
            throw new SQLExceptionWrapper((Throwable)e);
        }
    }

    public String toString() {
        CharBuffer cb = CharBuffer.allocate();
        cb.append("SelectQuery[");
        cb.append("SELECT ");
        if (this._results != null) {
            for (int i = 0; i < this._results.length; ++i) {
                if (i != 0) {
                    cb.append(",");
                }
                cb.append((Object)this._results[i]);
            }
        } else {
            cb.append("... unknown ...");
        }
        cb.append(" FROM ");
        FromItem[] fromItems = this.getFromItems();
        for (int i = 0; i < fromItems.length; ++i) {
            if (i != 0) {
                cb.append(",");
            }
            cb.append((Object)fromItems[i]);
        }
        if (this._whereExpr != null) {
            cb.append(" WHERE " + this._whereExpr);
        }
        cb.append("]");
        return cb.close();
    }
}

