/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.jdbc;

import com.caucho.db.Database;
import com.caucho.db.jdbc.ConnectionImpl;
import com.caucho.util.L10N;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.ArrayList;
import javax.sql.ConnectionEvent;
import javax.sql.ConnectionEventListener;
import javax.sql.PooledConnection;
import javax.sql.StatementEventListener;

class PooledConnectionImpl
implements PooledConnection {
    private static final L10N L = new L10N(PooledConnectionImpl.class);
    private final Database _db;
    private ArrayList<ConnectionEventListener> _listeners = new ArrayList();
    private boolean _isClosed;

    PooledConnectionImpl(Database db) {
        this._db = db;
        if (this._db == null) {
            throw new NullPointerException();
        }
    }

    Database getDatabase() {
        return this._db;
    }

    @Override
    public Connection getConnection() throws SQLException {
        if (this._isClosed) {
            throw new IllegalStateException(L.l("getting connection after close"));
        }
        return new ConnectionImpl(this);
    }

    @Override
    public void addConnectionEventListener(ConnectionEventListener listener) {
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
        }
    }

    @Override
    public void removeConnectionEventListener(ConnectionEventListener listener) {
        this._listeners.remove(listener);
    }

    void closeEvent(Connection conn) {
        ConnectionEvent event = new ConnectionEvent(this);
        for (int i = 0; i < this._listeners.size(); ++i) {
            ConnectionEventListener listener = this._listeners.get(i);
            listener.connectionClosed(event);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._db + "]";
    }

    @Override
    public void close() throws SQLException {
        this._isClosed = true;
    }

    @Override
    public void addStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }

    @Override
    public void removeStatementEventListener(StatementEventListener listener) {
        throw new UnsupportedOperationException("Not supported yet.");
    }
}

