/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.block;

import com.caucho.db.block.Block;
import com.caucho.db.block.BlockStore;
import com.caucho.db.block.BlockWriteQueue;
import com.caucho.env.shutdown.ShutdownSystem;
import com.caucho.env.thread.AbstractTaskWorker;
import com.caucho.util.CurrentTime;
import com.caucho.util.RingValueQueue;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockWriter
extends AbstractTaskWorker {
    private static final Logger log = Logger.getLogger(BlockWriter.class.getName());
    private final BlockStore _store;
    private final BlockWriteQueue _blockWriteQueue = new BlockWriteQueue(this);
    private int _queueSize = 16384;
    private final RingValueQueue<Block> _blockWriteRing = new RingValueQueue(this._queueSize);

    BlockWriter(BlockStore store) {
        this._store = store;
        store.getReadWrite();
    }

    void addDirtyBlock(Block block) {
        this.addDirtyBlockNoWake(block);
        if (!this.isQueueEmpty()) {
            this.wake();
        }
    }

    protected boolean isWeakClose() {
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void XX_addDirtyBlockNoWake(Block block) {
        boolean isWake = false;
        BlockWriteQueue blockWriteQueue = this._blockWriteQueue;
        synchronized (blockWriteQueue) {
            if (this._blockWriteQueue.isFilled()) {
                isWake = true;
            }
            this._blockWriteQueue.addDirtyBlock(block);
        }
        if (isWake) {
            this.wake();
        }
    }

    void addDirtyBlockNoWake(Block block) {
        if (this._blockWriteRing.offer((Object)block, 0L, TimeUnit.SECONDS)) {
            return;
        }
        this.wake();
        if (this.isClosed()) {
            return;
        }
        if (!this._blockWriteRing.offer((Object)block, 180L, TimeUnit.SECONDS)) {
            String message = "OFFER_FAILED: " + block + " head:" + this._blockWriteRing.getHead() + " tail:" + this._blockWriteRing.getTail();
            ShutdownSystem.getCurrent().startFailSafeShutdown("shutting down due to: " + message);
        }
        this.wake();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean XX_copyDirtyBlock(long blockId, Block block) {
        Block writeBlock = null;
        BlockWriteQueue blockWriteQueue = this._blockWriteQueue;
        synchronized (blockWriteQueue) {
            writeBlock = this._blockWriteQueue.findBlock(blockId);
        }
        if (writeBlock != null) {
            return writeBlock.copyToBlock(block);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    boolean copyDirtyBlock(long blockId, Block block) {
        Block writeBlock;
        boolean isCopy = false;
        do {
            BlockWriteQueue blockWriteQueue = this._blockWriteQueue;
            synchronized (blockWriteQueue) {
                writeBlock = this.findBlock(blockId);
                if (writeBlock != null) {
                    isCopy = writeBlock.copyToBlock(block);
                }
            }
        } while (writeBlock != null && !isCopy);
        return writeBlock != null;
    }

    private Block findBlock(long blockId) {
        long ptr = this._blockWriteRing.getTail();
        Block matchBlock = null;
        while (ptr < this._blockWriteRing.getHead()) {
            Block testBlock = (Block)this._blockWriteRing.getValue(ptr);
            if (testBlock == null) {
                ptr = Math.max(ptr, this._blockWriteRing.getTail());
                continue;
            }
            ++ptr;
            if (testBlock.getBlockId() != blockId) continue;
            matchBlock = testBlock;
        }
        return matchBlock;
    }

    boolean XX_waitForComplete(long timeout) {
        this.wake();
        this._blockWriteQueue.waitForComplete(timeout);
        return true;
    }

    boolean waitForComplete(long timeout) {
        long expire = CurrentTime.getCurrentTimeActual() + timeout;
        boolean isEmpty = false;
        do {
            this.wake();
            try {
                Thread.sleep(10L);
            }
            catch (Exception exception) {
                // empty catch block
            }
        } while (!this.isClosed() && !(isEmpty = this._blockWriteRing.isEmpty()) && CurrentTime.getCurrentTimeActual() < expire);
        return this.isClosed() || isEmpty;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long runTask() {
        try {
            int retryMax;
            int retry = retryMax = 25;
            while (true) {
                Block block;
                if ((block = this.peekFirstBlock()) != null) {
                    retry = retryMax;
                    try {
                        block.writeFromBlockWriter();
                    }
                    finally {
                        this.removeFirstBlock();
                    }
                    continue;
                }
                if (this.isQueueEmpty() && retry-- <= 0) break;
            }
            return -1L;
        }
        catch (Throwable e) {
            log.log(Level.WARNING, e.toString(), e);
            return -1L;
        }
    }

    private boolean isQueueEmpty() {
        return this._blockWriteRing.isEmpty();
    }

    public void wakeIfPending() {
        if (!this.isQueueEmpty()) {
            this.wake();
        }
    }

    private Block peekFirstBlock() {
        return (Block)this._blockWriteRing.peek();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void removeFirstBlock() {
        RingValueQueue<Block> ringValueQueue = this._blockWriteRing;
        synchronized (ringValueQueue) {
            this._blockWriteRing.poll();
        }
    }

    protected void onThreadStart() {
    }

    protected void onThreadComplete() {
    }

    public String toString() {
        return ((Object)((Object)this)).getClass().getSimpleName() + "[" + this._store + "]";
    }
}

