/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.db.block;

import com.caucho.db.block.Block;
import com.caucho.db.block.BlockWriter;
import com.caucho.util.CurrentTime;
import java.util.logging.Level;
import java.util.logging.Logger;

public class BlockWriteQueue {
    private static final Logger log = Logger.getLogger(BlockWriteQueue.class.getName());
    private final BlockWriter _writer;
    private final int _queueSize = 1024;
    private final Block[] _writeQueue = new Block[1024];
    private int _head;
    private int _tail;
    private boolean _isWait;

    BlockWriteQueue(BlockWriter writer) {
        this._writer = writer;
    }

    void addDirtyBlock(Block block) {
        Block foundBlock = this.findBlock(block.getBlockId());
        if (foundBlock == block) {
            return;
        }
        while (true) {
            int head;
            int nextHead;
            if ((nextHead = ((head = this._head) + 1) % 1024) != this._tail) {
                this._writeQueue[head] = block;
                this._head = nextHead;
                return;
            }
            this._writer.wake();
            try {
                this._isWait = true;
                this.wait(100L);
                continue;
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
                continue;
            }
            break;
        }
    }

    Block peekFirstBlock() {
        Block block = this._writeQueue[this._tail];
        return block;
    }

    void removeFirstBlock() {
        int head = this._head;
        int tail = this._tail;
        if (head == tail) {
            throw new IllegalStateException();
        }
        this._writeQueue[tail] = null;
        this._tail = (tail + 1) % 1024;
        this.wake();
    }

    Block findBlock(long blockId) {
        int m1 = 1023;
        int ptr = (this._head + m1) % 1024;
        int prevTail = (this._tail + m1) % 1024;
        while (ptr != prevTail) {
            Block testBlock = this._writeQueue[ptr];
            if (testBlock != null && testBlock.getBlockId() == blockId) {
                return testBlock;
            }
            ptr = (ptr + m1) % 1024;
        }
        return null;
    }

    boolean waitForComplete(long timeout) {
        long expireTime = CurrentTime.getCurrentTimeActual() + timeout;
        while (CurrentTime.getCurrentTimeActual() < expireTime) {
            if (this.isEmpty()) {
                return true;
            }
            this._isWait = true;
            try {
                this.wait(100L);
            }
            catch (Exception exception) {}
        }
        return false;
    }

    boolean isEmpty() {
        return this._head == this._tail;
    }

    boolean isFilled() {
        int length = (this._head - this._tail + 1024) % 1024;
        return 1024 <= 4 * length;
    }

    private void wake() {
        boolean isWait = this._isWait;
        this._isWait = false;
        if (isWait) {
            this.notifyAll();
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }
}

