/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.topology;

import com.caucho.cloud.topology.TriadDispatcher;
import com.caucho.cloud.topology.TriadDispatcherSingle;
import com.caucho.cloud.topology.TriadOwner;

public class TriadDispatcherDouble<X>
extends TriadDispatcher<X> {
    private final X _valueA;
    private final X _valueB;

    public TriadDispatcherDouble(X valueA, X valueB) {
        this._valueA = valueA;
        this._valueB = valueB;
        if (valueA == null) {
            throw new NullPointerException();
        }
        if (valueB == null) {
            throw new NullPointerException();
        }
    }

    public static <T> TriadDispatcher<T> create(T valueA, T valueB) {
        if (valueA == null) {
            return new TriadDispatcherSingle<T>(valueB);
        }
        if (valueB == null) {
            return new TriadDispatcherSingle<T>(valueA);
        }
        return new TriadDispatcherDouble<T>(valueA, valueB);
    }

    @Override
    public X getA() {
        return this._valueA;
    }

    @Override
    public X getB() {
        return this._valueB;
    }

    @Override
    public X primary(TriadOwner owner) {
        switch (owner) {
            case A_B: 
            case A_C: {
                return this._valueA;
            }
            case B_A: 
            case B_C: {
                return this._valueB;
            }
            case C_A: {
                return this._valueA;
            }
            case C_B: {
                return this._valueB;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public X secondary(TriadOwner owner) {
        switch (owner) {
            case A_B: 
            case A_C: {
                return this._valueB;
            }
            case B_A: 
            case B_C: {
                return this._valueA;
            }
            case C_A: {
                return this._valueB;
            }
            case C_B: {
                return this._valueA;
            }
        }
        throw new IllegalStateException();
    }

    @Override
    public X tertiary(TriadOwner owner) {
        return null;
    }
}

