/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.cloud.network;

import com.caucho.cloud.network.NetworkListenSystem;
import com.caucho.config.ConfigException;
import com.caucho.config.Configurable;
import com.caucho.config.program.ConfigProgram;
import com.caucho.config.program.ContainerProgram;
import com.caucho.config.types.Period;
import com.caucho.network.listen.AbstractProtocol;
import com.caucho.network.listen.TcpPort;
import com.caucho.server.cluster.ProtocolPort;
import com.caucho.server.cluster.ProtocolPortConfig;
import com.caucho.server.http.HttpProtocol;
import java.util.logging.Logger;

public class NetworkServerConfig {
    private static final Logger log = Logger.getLogger(NetworkServerConfig.class.getName());
    private NetworkListenSystem _listenService;
    private ContainerProgram _listenerDefaults = new ContainerProgram();
    private boolean _isKeepaliveSelectEnable = true;

    NetworkServerConfig(NetworkListenSystem listenService) {
        this._listenService = listenService;
    }

    private NetworkListenSystem getListenService() {
        return this._listenService;
    }

    @Configurable
    public TcpPort createClusterPort() {
        return this.getListenService().getClusterListener();
    }

    protected TcpPort getClusterListener() {
        return this.getListenService().getClusterListener();
    }

    @Configurable
    public void setClusterIdleTime(Period period) {
        this.getClusterListener().setKeepaliveTimeout(period);
    }

    @Configurable
    public void setClusterSocketTimeout(Period period) {
        this.getClusterListener().setSocketTimeout(period);
    }

    @Configurable
    public void setKeepaliveSelectEnable(boolean isEnable) {
        this._isKeepaliveSelectEnable = isEnable;
        if (this.getClusterListener() != null) {
            this.getClusterListener().setKeepaliveSelectEnable(isEnable);
        }
    }

    public boolean isKeepaliveSelectEnable() {
        return this._isKeepaliveSelectEnable;
    }

    @Configurable
    public TcpPort createHttp() throws ConfigException {
        TcpPort listener = new TcpPort();
        this.applyPortDefaults(listener);
        HttpProtocol protocol = new HttpProtocol();
        listener.setProtocol(protocol);
        return listener;
    }

    public void addHttp(TcpPort listener) {
        if (listener.getPort() <= 0) {
            log.fine(listener + " skipping because port is 0.");
            return;
        }
        this.getListenService().addListener(listener);
    }

    @Configurable
    public TcpPort createProtocol() {
        ProtocolPortConfig port = new ProtocolPortConfig();
        this.getListenService().addListener(port);
        return port;
    }

    @Configurable
    public TcpPort createListen() {
        ProtocolPortConfig listener = new ProtocolPortConfig();
        return listener;
    }

    public void addListen(TcpPort listener) {
        if (listener.getPort() <= 0) {
            log.fine(listener + " skipping because port is 0.");
            return;
        }
        this.getListenService().addListener(listener);
    }

    @Configurable
    public void add(ProtocolPort protocolPort) {
        TcpPort listener = new TcpPort();
        AbstractProtocol protocol = protocolPort.getProtocol();
        listener.setProtocol(protocol);
        this.applyPortDefaults(listener);
        protocolPort.getConfigProgram().configure((Object)listener);
        this.getListenService().addListener(listener);
    }

    @Configurable
    public void addPortDefault(ContainerProgram program) {
        this.addListenDefault((ConfigProgram)program);
    }

    @Configurable
    public void addListenDefault(ConfigProgram program) {
        this._listenerDefaults.addProgram(program);
    }

    @Configurable
    public void setBindPortsAfterStart(boolean bindAtEnd) {
        this.getListenService().setBindPortsAfterStart(bindAtEnd);
    }

    @Configurable
    public void addContentProgram(ConfigProgram builder) {
        this._listenerDefaults.addProgram(builder);
    }

    private void applyPortDefaults(TcpPort port) {
        this._listenerDefaults.configure((Object)port);
        port.setKeepaliveSelectEnable(this.isKeepaliveSelectEnable());
    }
}

