/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractManagementCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.server.admin.ManagerClient;
import com.caucho.server.admin.StringQueryReply;
import com.caucho.util.L10N;

public class ProfileCommand
extends AbstractManagementCommand {
    private static final L10N L = new L10N(ProfileCommand.class);

    @Override
    protected void initBootOptions() {
        this.addValueOption("active-time", "time", "profiling time span, defualts to 5 sec");
        this.addValueOption("sampling-rate", "ms", "the sample rate defaults to 10ms");
        this.addValueOption("depth", "count", "the stack trace depth (default 16)");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "gathers a CPU profile of a running server";
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        long activeTime = 5000L;
        String activeTimeArg = args.getArg("-active-time");
        if (activeTimeArg != null) {
            activeTime = Long.parseLong(activeTimeArg);
        }
        long period = 10L;
        String periodArg = args.getArg("-sampling-rate");
        if (periodArg != null) {
            period = Long.parseLong(periodArg);
        }
        int depth = 16;
        String depthArg = args.getArg("-depth");
        if (depthArg != null) {
            depth = Integer.parseInt(depthArg);
        }
        StringQueryReply result = managerClient.profile(activeTime, period, depth);
        System.out.println(result.getValue());
        return 0;
    }
}

