/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.JmxCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.server.admin.JsonQueryReply;
import com.caucho.server.admin.ManagerClient;
import com.caucho.util.IoUtil;
import com.caucho.util.L10N;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;

public class JmxDumpCommand
extends JmxCommand {
    private static final L10N L = new L10N(JmxDumpCommand.class);

    @Override
    protected void initBootOptions() {
        this.addValueOption("file", "file", "file where the JMX dump will be saved");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "dumps all JMX values from a Resin server";
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, ManagerClient managerClient) {
        JsonQueryReply result;
        JsonQueryReply queryResult = result = managerClient.doJmxDump();
        String fileName = args.getArg("-file");
        if (fileName == null) {
            System.out.println(queryResult.getValue());
            return 0;
        }
        FileWriter out = null;
        try {
            File file = new File(fileName);
            out = new FileWriter(file);
            out.write(queryResult.getValue());
            ((Writer)out).flush();
            System.out.println(L.l("JMX dump was written to '{0}'", (Object)file.getCanonicalPath()));
            int n = 0;
            IoUtil.close((Writer)out);
            return n;
        }
        catch (IOException e) {
            e.printStackTrace();
            int n = 4;
            return n;
        }
        finally {
            IoUtil.close(out);
        }
    }
}

