/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractRepositoryCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.server.admin.WebAppDeployClient;
import com.caucho.server.deploy.DeployClient;
import com.caucho.util.L10N;

public class DeployCopyCommand
extends AbstractRepositoryCommand {
    private static final L10N L = new L10N(DeployCopyCommand.class);

    @Override
    protected void initBootOptions() {
        this.addValueOption("source", "source", "source context");
        this.addValueOption("source-host", "source-host", "source host");
        this.addValueOption("source-stage", "source-stage", "source stage");
        this.addValueOption("source-version", "source-version", "source version");
        this.addSpacerOption();
        this.addValueOption("target", "target", "target context");
        this.addValueOption("target-host", "target-host", "target host");
        this.addValueOption("target-stage", "target-stage", "target stage");
        this.addValueOption("target-version", "target-version", "target version");
        this.addSpacerOption();
        this.addValueOption("m", "message", "commit message");
        super.initBootOptions();
    }

    @Override
    public String getDescription() {
        return "copies a deployment to a new tag name";
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, WebAppDeployClient deployClient) {
        String targetHost;
        String targetContext;
        String sourceHost;
        String sourceContext = args.getArg("-source");
        if (sourceContext == null) {
            if (args.getTailArgs().size() == 2) {
                sourceContext = args.getTailArgs().get(0);
            } else {
                throw new ConfigException("must specify -source attribute");
            }
        }
        if ((sourceHost = args.getArg("-source-host")) == null) {
            sourceHost = "default";
        }
        CommitBuilder source = new CommitBuilder();
        source.type("webapp");
        String sourceStage = args.getArg("-source-stage");
        if (sourceStage != null) {
            source.stage(sourceStage);
        }
        source.tagKey(sourceHost + "/" + sourceContext);
        String version = args.getArg("-source-version");
        if (version != null) {
            DeployClient.fillInVersion(source, version);
        }
        if ((targetContext = args.getArg("-target")) == null) {
            if (args.getTailArgs().size() == 2) {
                targetContext = args.getTailArgs().get(1);
            } else {
                throw new ConfigException("must specify -target attribute");
            }
        }
        if ((targetHost = args.getArg("-target-host")) == null) {
            targetHost = sourceHost;
        }
        CommitBuilder target = new CommitBuilder();
        target.type("webapp");
        String targetStage = args.getArg("-target-stage");
        if (targetStage != null) {
            target.stage(targetStage);
        }
        target.tagKey(targetHost + "/" + targetContext);
        String message = args.getArg("-m");
        if (message == null) {
            message = args.getArg("-message");
        }
        if (message == null) {
            message = L.l("copy '{0}' to '{1}'", (Object)source.getTagKey(), (Object)target.getTagKey());
        }
        target.message(message);
        target.attribute("user", System.getProperty("user.name"));
        String targetVersion = args.getArg("-target-version");
        if (targetVersion != null) {
            DeployClient.fillInVersion(target, targetVersion);
        }
        deployClient.copyTag(target, source);
        System.out.println(L.l("copied {0} to {1}", (Object)source.getId(), (Object)target.getId()));
        return 0;
    }
}

