/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.boot;

import com.caucho.boot.AbstractRepositoryCommand;
import com.caucho.boot.WatchdogArgs;
import com.caucho.boot.WatchdogClient;
import com.caucho.config.ConfigException;
import com.caucho.env.repository.CommitBuilder;
import com.caucho.server.admin.WebAppDeployClient;
import java.io.IOException;

public abstract class AbstractDeployLsCommand
extends AbstractRepositoryCommand {
    @Override
    protected void initBootOptions() {
        this.addValueOption("stage", "stage", "stage to deploy application to, defaults to production");
        this.addValueOption("version", "version", "version of application formatted as <major.minor.micro.qualifier>");
        super.initBootOptions();
    }

    @Override
    public boolean isDefaultArgsAccepted() {
        return true;
    }

    @Override
    public String getDescription() {
        return "lists the configuration files";
    }

    @Override
    public String getUsageArgs() {
        return " <filename>";
    }

    @Override
    public int doCommand(WatchdogArgs args, WatchdogClient client, WebAppDeployClient deployClient) {
        String fileName = args.getDefaultArg();
        CommitBuilder commit = this.createCommitBuilder(args);
        try {
            String[] files = deployClient.listFiles(commit.getId(), fileName);
            if (files != null) {
                for (String file : files) {
                    System.out.println(file);
                }
            }
        }
        catch (IOException e) {
            throw ConfigException.create((Throwable)e);
        }
        return 0;
    }

    protected abstract CommitBuilder createCommitBuilder(WatchdogArgs var1);
}

