/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.query;

import com.caucho.bam.BamError;
import com.caucho.bam.query.AbstractQueryCallback;
import com.caucho.util.CurrentTime;
import com.caucho.util.L10N;
import java.io.Serializable;
import java.util.concurrent.locks.LockSupport;

public class QueryFutureCallback
extends AbstractQueryCallback {
    private static final L10N L = new L10N(QueryFutureCallback.class);
    private volatile ResultStateEnum _state = ResultStateEnum.WAITING;
    private volatile Serializable _result;
    private volatile BamError _error;
    private volatile Thread _thread;

    @Override
    public void onQueryResult(String to, String from, Serializable result) {
        this._result = result;
        this._state = ResultStateEnum.REPLY;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    @Override
    public void onQueryError(String to, String from, Serializable payload, BamError error) {
        this._error = error;
        this._state = ResultStateEnum.ERROR;
        Thread thread = this._thread;
        if (thread != null) {
            LockSupport.unpark(thread);
        }
    }

    public Serializable get(long timeout) {
        this._thread = Thread.currentThread();
        try {
            switch (this._state) {
                case REPLY: {
                    Serializable serializable = this._result;
                    return serializable;
                }
                case ERROR: {
                    throw this._error.createException();
                }
            }
            long expireTime = CurrentTime.getCurrentTimeActual() + timeout;
            do {
                LockSupport.parkUntil(expireTime);
                switch (this._state) {
                    case REPLY: {
                        Serializable serializable = this._result;
                        return serializable;
                    }
                    case ERROR: {
                        throw this._error.createException();
                    }
                }
            } while (CurrentTime.getCurrentTimeActual() < expireTime);
            throw new IllegalStateException(L.l(this + " future timeout: " + timeout + "ms"));
        }
        finally {
            this._thread = null;
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[]";
    }

    static enum ResultStateEnum {
        WAITING,
        REPLY,
        ERROR;

    }
}

