/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.packet;

import com.caucho.bam.BamError;
import com.caucho.bam.packet.Packet;
import com.caucho.bam.stream.MessageStream;
import java.io.Serializable;

public class QueryError
extends Packet {
    private final long _id;
    private final Serializable _value;
    private final BamError _error;

    private QueryError() {
        this._id = 0L;
        this._value = null;
        this._error = null;
    }

    public QueryError(long id, String to, String from, Serializable value, BamError error) {
        super(to, from);
        this._id = id;
        this._value = value;
        this._error = error;
    }

    public long getId() {
        return this._id;
    }

    public Serializable getValue() {
        return this._value;
    }

    public BamError getError() {
        return this._error;
    }

    @Override
    public void dispatch(MessageStream handler, MessageStream toSource) {
        handler.queryError(this.getId(), this.getTo(), this.getFrom(), this.getValue(), this.getError());
    }

    @Override
    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append(this.getClass().getSimpleName());
        sb.append("[");
        sb.append("id=");
        sb.append(this._id);
        if (this.getTo() != null) {
            sb.append(",to=");
            sb.append(this.getTo());
        }
        if (this.getFrom() != null) {
            sb.append(",from=");
            sb.append(this.getFrom());
        }
        if (this._value != null) {
            sb.append("," + this._value.getClass().getName());
        }
        if (this._error != null) {
            sb.append(",error=" + this._error);
        }
        sb.append("]");
        return sb.toString();
    }
}

