/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.bam.broker;

import com.caucho.bam.actor.AbstractAgent;
import com.caucho.bam.actor.Agent;
import com.caucho.bam.broker.AbstractBroker;
import com.caucho.bam.broker.ManagedBroker;
import com.caucho.bam.mailbox.Mailbox;
import com.caucho.bam.mailbox.MailboxType;
import com.caucho.bam.mailbox.MultiworkerMailbox;
import com.caucho.bam.mailbox.PassthroughMailbox;
import com.caucho.bam.stream.MessageStream;
import com.caucho.util.CurrentTime;
import java.util.concurrent.atomic.AtomicLong;

public abstract class AbstractManagedBroker
extends AbstractBroker
implements ManagedBroker {
    private final AtomicLong _sequence = new AtomicLong(CurrentTime.getCurrentTime());

    @Override
    public void addMailbox(String address, Mailbox mailbox) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public void removeMailbox(Mailbox mailbox) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    @Override
    public Agent createAgent(MessageStream actorStream) {
        return this.createAgent(actorStream, MailboxType.DEFAULT);
    }

    @Override
    public Agent createAgent(MessageStream actorStream, MailboxType mailboxType) {
        String address = actorStream.getAddress();
        Mailbox mailbox = this.createMailbox(address, actorStream, mailboxType);
        AbstractAgent agent = new AbstractAgent(actorStream.getAddress(), mailbox, this);
        this.addMailbox(address, mailbox);
        return agent;
    }

    protected Mailbox createMailbox(MessageStream actorStream, MailboxType mailboxType) {
        return this.createMailbox(actorStream.getAddress(), actorStream, mailboxType);
    }

    protected Mailbox createMailbox(String address, MessageStream actorStream, MailboxType mailboxType) {
        switch (mailboxType) {
            case NON_QUEUED: {
                return new PassthroughMailbox(address, actorStream, this);
            }
        }
        return new MultiworkerMailbox(address, actorStream, this, 5);
    }

    @Override
    public Mailbox createClient(Mailbox next, String uid, String resource) {
        Mailbox mailbox;
        String address = null;
        if (uid == null) {
            uid = Long.toHexString(this._sequence.incrementAndGet());
        }
        if (uid.indexOf(64) < 0) {
            uid = uid + '@' + this.getAddress();
        }
        if (resource != null) {
            address = uid + "/" + resource;
            mailbox = this.getMailbox(address);
            if (mailbox != null) {
                address = uid + "/" + resource + "-" + Long.toHexString(this._sequence.incrementAndGet());
            }
        } else {
            address = uid + "/" + Long.toHexString(this._sequence.incrementAndGet());
        }
        mailbox = new PassthroughMailbox(address, next, this);
        this.addMailbox(address, mailbox);
        return mailbox;
    }

    @Override
    public boolean isClosed() {
        return false;
    }
}

