/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.io;

import com.caucho.amqp.io.AmqpAbstractComposite;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.AmqpWriter;
import com.caucho.message.DistributionMode;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.List;
import java.util.Map;

public class LinkSource
extends AmqpAbstractComposite {
    private static final L10N L = new L10N(LinkSource.class);
    private String _address;
    private Durability _durable;
    private ExpiryPolicy _expiryPolicy;
    private long _timeout;
    private boolean _isDynamic;
    private Map<String, Object> _dynamicNodeProperties;
    private DistributionMode _distributionMode;
    private Map<String, ?> _filter;
    private String _defaultOutcome;
    private List<String> _outcomes;
    private List<String> _capabilities;

    public String getAddress() {
        return this._address;
    }

    public void setAddress(String address) {
        this._address = address;
    }

    public Durability getDurable() {
        return this._durable;
    }

    public ExpiryPolicy getExpiryPolicy() {
        return this._expiryPolicy;
    }

    public long getTimeout() {
        return this._timeout;
    }

    public boolean isDynamic() {
        return this._isDynamic;
    }

    public void setDynamicNodeProperties(Map<String, Object> props) {
        this._dynamicNodeProperties = props;
    }

    public Map<String, Object> getDynamicNodeProperties() {
        return this._dynamicNodeProperties;
    }

    public DistributionMode getDistributionMode() {
        return this._distributionMode;
    }

    public void setDistributionMode(DistributionMode distMode) {
        this._distributionMode = distMode;
    }

    public Map<String, ?> getFilter() {
        return this._filter;
    }

    public String getDefaultOutcome() {
        return this._defaultOutcome;
    }

    public List<String> getOutcomes() {
        return this._outcomes;
    }

    public List<String> getCapabilities() {
        return this._capabilities;
    }

    @Override
    public long getDescriptorCode() {
        return 40L;
    }

    @Override
    public LinkSource createInstance() {
        return new LinkSource();
    }

    @Override
    public void readBody(AmqpReader in, int count) throws IOException {
        this._address = in.readString();
        this._durable = Durability.values()[in.readInt()];
        this._expiryPolicy = ExpiryPolicy.find(in.readSymbol());
        this._timeout = in.readLong();
        this._isDynamic = in.readBoolean();
        this._dynamicNodeProperties = in.readFieldMap();
        this._distributionMode = DistributionMode.find(in.readSymbol());
        this._filter = in.readFieldMap();
        this._defaultOutcome = in.readSymbol();
        this._outcomes = in.readSymbolArray();
        this._capabilities = in.readSymbolArray();
    }

    @Override
    public int writeBody(AmqpWriter out) throws IOException {
        out.writeString(this._address);
        if (this._durable != null) {
            out.writeUint(this._durable.ordinal());
        } else {
            out.writeNull();
        }
        if (this._expiryPolicy != null) {
            out.writeSymbol(this._expiryPolicy.getName());
        } else {
            out.writeNull();
        }
        out.writeUint((int)this._timeout);
        out.writeBoolean(this._isDynamic);
        out.writeFieldsMap(this._dynamicNodeProperties);
        if (this._distributionMode != null) {
            out.writeSymbol(this._distributionMode.getName());
        } else {
            out.writeNull();
        }
        out.writeMap(this._filter);
        out.writeSymbol(this._defaultOutcome);
        out.writeSymbolArray(this._outcomes);
        out.writeSymbolArray(this._capabilities);
        return 11;
    }

    public static enum ExpiryPolicy {
        LINK_DETACH("link-detach"),
        SESSION_END("session-end"),
        CONNECTION_CLOSE("connection-close"),
        NEVER("never");

        private String _name;

        private ExpiryPolicy(String name) {
            this._name = name;
        }

        public String getName() {
            return this._name;
        }

        public static ExpiryPolicy find(String name) {
            if (name == null) {
                return null;
            }
            if ("link-detach".equals(name)) {
                return LINK_DETACH;
            }
            if ("session-end".equals(name)) {
                return SESSION_END;
            }
            if ("connection-close".equals(name)) {
                return CONNECTION_CLOSE;
            }
            if ("never".equals(name)) {
                return NEVER;
            }
            throw new IllegalArgumentException(L.l("unknown type: " + name));
        }
    }

    public static enum Durability {
        NONE,
        CONFIGURATION,
        UNSETTLED_STATE;

    }
}

