/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.common;

import com.caucho.amqp.common.AmqpLink;
import com.caucho.amqp.io.AmqpError;
import com.caucho.amqp.io.DeliveryState;
import com.caucho.message.SettleMode;
import java.util.logging.Level;
import java.util.logging.Logger;

public class DeliveryNode {
    private static final Logger log = Logger.getLogger(DeliveryNode.class.getName());
    private final long _deliveryId;
    private final AmqpLink _link;
    private final long _messageId;
    private final SettleMode _settleMode;

    DeliveryNode(long deliveryId, AmqpLink link, long messageId, SettleMode settleMode) {
        this._deliveryId = deliveryId;
        this._link = link;
        this._messageId = messageId;
        this._settleMode = settleMode;
    }

    public long getDeliveryId() {
        return this._deliveryId;
    }

    public long getMessageId() {
        return this._messageId;
    }

    public AmqpLink getLink() {
        return this._link;
    }

    public void onAccepted(long xid) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this._link + " onAccepted(" + this._messageId + ")");
        }
        if (this._settleMode == SettleMode.EXACTLY_ONCE) {
            this._link.getSession().outgoingAccepted(this._messageId);
        }
        this._link.onAccepted(xid, this._messageId);
    }

    public void onReleased(long xid) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this._link + " onReleased(" + this._messageId + ")");
        }
        this._link.onReleased(xid, this._messageId);
    }

    public void onRejected(long xid, AmqpError error) {
        if (log.isLoggable(Level.FINER)) {
            log.finer(this._link + " onRejected(" + this._messageId + "," + error + ")");
        }
        System.out.println("ONR " + this._link + " " + error);
        this._link.onRejected(xid, this._messageId, error);
    }

    public void onModified(long xid, boolean isFailed, boolean isUndeliverableHere) {
        this._link.onModified(xid, this._messageId, isFailed, isUndeliverableHere);
    }

    public void onReceived(long xid) {
    }

    public void onXa(long xid, byte[] txnId, DeliveryState outcome) {
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._deliveryId + "]";
    }
}

