/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amqp.common;

import com.caucho.amqp.common.AmqpSession;
import com.caucho.amqp.io.AmqpError;
import com.caucho.amqp.io.AmqpReader;
import com.caucho.amqp.io.FrameAttach;
import com.caucho.amqp.io.FrameFlow;
import com.caucho.amqp.io.FrameTransfer;
import java.io.IOException;
import java.util.Map;

public abstract class AmqpLink {
    private final String _name;
    private final String _address;
    private int _incomingHandle = -1;
    private int _outgoingHandle = -1;
    private AmqpSession _session;

    public AmqpLink(String name, String address) {
        this._name = name;
        this._address = address;
    }

    public String getName() {
        return this._name;
    }

    public String getAddress() {
        return this._address;
    }

    public abstract FrameAttach.Role getRole();

    public Map<String, Object> getAttachProperties() {
        return null;
    }

    public Map<String, Object> getSourceProperties() {
        return null;
    }

    public Map<String, Object> getTargetProperties() {
        return null;
    }

    public AmqpSession getSession() {
        return this._session;
    }

    void setSession(AmqpSession session) {
        if (this._session != null) {
            throw new IllegalStateException();
        }
        this._session = session;
    }

    public int getIncomingHandle() {
        return this._incomingHandle;
    }

    public void setIncomingHandle(int handle) {
        this._incomingHandle = handle;
    }

    public int getOutgoingHandle() {
        return this._outgoingHandle;
    }

    public void setOutgoingHandle(int handle) {
        this._outgoingHandle = handle;
    }

    public void afterAttach() {
    }

    protected void onTransfer(FrameTransfer transfer, AmqpReader ain) throws IOException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void onAccepted(long xid, long messageId) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void onRejected(long xid, long messageId, AmqpError error) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void onReleased(long xid, long messageId) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void onModified(long xid, long mid, boolean isFailed, boolean isUndeliverableHere) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void accepted(long mid) {
    }

    public void rejected(long mid, String errorMessage) {
    }

    public void modified(long mid, boolean isFailure, boolean isUndeliverableHere) {
    }

    public void released(long mid) {
    }

    public long getDeliveryCount() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void setPeerDeliveryCount(long deliveryCount) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public void onFlow(FrameFlow flow) {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this.getName() + "]";
    }
}

