/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Timestamp;

public class SqlTimestampType
extends AmberType {
    private static final L10N L = new L10N(SqlTimestampType.class);
    private static final SqlTimestampType SQL_TIMESTAMP_TYPE = new SqlTimestampType();

    private SqlTimestampType() {
    }

    public static SqlTimestampType create() {
        return SQL_TIMESTAMP_TYPE;
    }

    @Override
    public String getName() {
        return "java.sql.Timestamp";
    }

    @Override
    public boolean isAssignableTo(Class javaType) {
        return javaType.isAssignableFrom(Timestamp.class);
    }

    @Override
    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(93, length, precision, scale);
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print(rs + ".getTimestamp(" + indexVar + " + " + index + ")");
        return index + 1;
    }

    @Override
    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("rs.getTimestamp(columnNames[" + index + "])");
        return index + 1;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.TIMESTAMP);");
        out.println("else");
        out.println("  " + pstmt + ".setTimestamp(" + index + "++, " + value + ");");
    }

    @Override
    public void generateSetVersion(JavaWriter out, String pstmt, String index, String value) throws IOException {
        value = "new java.sql.Timestamp(com.caucho.util.Alarm.getExactTime())";
        out.println(pstmt + ".setTimestamp(" + index + "++, " + value + ");");
    }

    @Override
    public String generateIncrementVersion(String value) throws IOException {
        return "new java.sql.Timestamp(com.caucho.util.Alarm.getExactTime())";
    }

    @Override
    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        pstmt.setTimestamp(index, (Timestamp)value);
    }

    @Override
    public Object getObject(ResultSet rs, int index) throws SQLException {
        return rs.getTimestamp(index);
    }
}

