/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.CharacterType;
import com.caucho.amber.type.PrimitiveType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PrimitiveCharType
extends PrimitiveType {
    private static final L10N L = new L10N(PrimitiveCharType.class);
    private static final PrimitiveCharType CHAR_TYPE = new PrimitiveCharType();

    private PrimitiveCharType() {
    }

    public static PrimitiveCharType create() {
        return CHAR_TYPE;
    }

    @Override
    public String getName() {
        return "char";
    }

    @Override
    public AmberType getForeignType() {
        return CharacterType.create();
    }

    @Override
    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(1, 0, precision, scale);
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.PrimitiveCharType.toChar(" + rs + ".getString(" + indexVar + " + " + index + "))");
        return index + 1;
    }

    @Override
    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.PrimitiveCharType.toChar(columnNames[" + index + "])");
        return index + 1;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println(pstmt + ".setString(" + index + "++, String.valueOf(" + value + "));");
    }

    @Override
    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.CHAR);");
    }

    @Override
    public String toObject(String value) {
        return "new Character(" + value + ")";
    }

    @Override
    public String generateCastFromObject(String value) {
        return "((Character) " + value + ").charValue()";
    }

    @Override
    public Object getObject(ResultSet rs, int index) throws SQLException {
        String v = rs.getString(index);
        return rs.wasNull() ? null : new Character(v.charAt(0));
    }

    public static char toChar(String value) {
        if (value == null || value.length() == 0) {
            return '\u0000';
        }
        return value.charAt(0);
    }

    @Override
    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (!(value instanceof Character) && !(value instanceof String)) {
            throw new IllegalArgumentException("Invalid argument for setParameter.");
        }
        pstmt.setString(index, value.toString());
    }
}

