/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class PrimitiveCharArrayType
extends AmberType {
    private static final L10N L = new L10N(PrimitiveCharArrayType.class);

    private PrimitiveCharArrayType() {
    }

    public static PrimitiveCharArrayType create() {
        return new PrimitiveCharArrayType();
    }

    @Override
    public String getName() {
        return "char[]";
    }

    @Override
    public String getJavaTypeName() {
        return "char[]";
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.PrimitiveCharArrayType.toCharArray(");
        out.print(rs + ".getString(" + indexVar + " + " + index + ")");
        out.print(", " + rs + ".wasNull())");
        return index + 1;
    }

    @Override
    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.PrimitiveCharArrayType.toCharArray(");
        out.print("rs.getString(columnNames[" + index + "])");
        out.print(", rs.wasNull())");
        return index + 1;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.CHAR);");
        out.println("else");
        out.println("  " + pstmt + ".setString(" + index + "++, new String(" + value + "));");
    }

    @Override
    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 1);
        } else {
            pstmt.setString(index, new String((char[])value));
        }
    }

    @Override
    public Object getObject(ResultSet rs, int index) throws SQLException {
        String s = rs.getString(index);
        if (rs.wasNull()) {
            return null;
        }
        return s.toCharArray();
    }

    public static char[] toCharArray(String v, boolean wasNull) {
        if (wasNull || v == null) {
            return null;
        }
        return v.toCharArray();
    }
}

