/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

public class LongType
extends AmberType {
    private static final L10N L = new L10N(LongType.class);
    private static final LongType LONG_TYPE = new LongType();

    private LongType() {
    }

    public static LongType create() {
        return LONG_TYPE;
    }

    @Override
    public String getName() {
        return "java.lang.Long";
    }

    @Override
    public boolean isNumeric() {
        return true;
    }

    @Override
    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        return manager.getCreateColumnSQL(-5, length, precision, scale);
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.LongType.toLong(" + rs + ".getLong(" + indexVar + " + " + index + "), " + rs + ".wasNull())");
        return index + 1;
    }

    @Override
    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        out.print("com.caucho.amber.type.LongType.toLong(rs.getLong(columnNames[" + index + "]),rs.wasNull())");
        return index + 1;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.BIGINT);");
        out.println("else");
        out.println("  " + pstmt + ".setLong(" + index + "++, " + value + ".longValue());");
    }

    @Override
    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.BIGINT);");
    }

    @Override
    public void generateSetVersion(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setLong(" + index + "++, 1);");
        out.println("else");
        out.println("  " + pstmt + ".setLong(" + index + "++, " + value + ".longValue() + 1);");
    }

    @Override
    public String generateIncrementVersion(String value) throws IOException {
        return value + ".longValue() + 1";
    }

    public static Long toLong(long value, boolean wasNull) {
        if (wasNull) {
            return null;
        }
        return new Long(value);
    }

    @Override
    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (value == null) {
            pstmt.setNull(index, 0);
        } else {
            pstmt.setLong(index, (Long)value);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int index) throws SQLException {
        long value = rs.getLong(index);
        return rs.wasNull() ? null : new Long(value);
    }
}

