/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.IntegerType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.io.IOException;
import java.lang.reflect.Method;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EnumType
extends AmberType {
    private static final Logger log = Log.open(EnumType.class);
    private static final L10N L = new L10N(EnumType.class);
    private Class _beanClass;
    private String _name;
    private boolean _isOrdinal = true;

    public Class getBeanClass() {
        return this._beanClass;
    }

    public void setBeanClass(Class beanClass) {
        this._beanClass = beanClass;
    }

    @Override
    public String getName() {
        return this._name;
    }

    public void setName(String name) {
        this._name = name;
    }

    @Override
    public boolean isNumeric() {
        return this.isOrdinal();
    }

    public boolean isOrdinal() {
        return this._isOrdinal;
    }

    public void setOrdinal(boolean isOrdinal) {
        this._isOrdinal = isOrdinal;
    }

    @Override
    public AmberType getForeignType() {
        return IntegerType.create();
    }

    @Override
    public String generateCreateColumnSQL(AmberPersistenceUnit manager, int length, int precision, int scale) {
        if (this._isOrdinal) {
            return manager.getCreateColumnSQL(4, length, precision, scale);
        }
        if (length == 0) {
            length = 255;
        }
        return "varchar(" + length + ")";
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        if (this._isOrdinal) {
            out.print("(" + this.getName() + ") com.caucho.amber.type.EnumType.toEnum(" + rs + ".getInt(" + indexVar + " + " + index + "), " + rs + ".wasNull(), " + this.getName() + ".values())");
        } else {
            out.print("(" + this.getName() + ") com.caucho.amber.type.EnumType.toEnum(" + rs + ".getString(" + indexVar + " + " + index + "), " + rs + ".wasNull(), " + this.getName() + ".class)");
        }
        return index + 1;
    }

    @Override
    public int generateLoadNative(JavaWriter out, int index) throws IOException {
        if (this._isOrdinal) {
            out.print("(" + this.getName() + ") com.caucho.amber.type.EnumType.toEnum(rs.getInt(columnNames[" + index + "]), rs.wasNull(), " + this.getName() + ".values())");
        } else {
            out.print("(" + this.getName() + ") com.caucho.amber.type.EnumType.toEnum(rs.getString(columnNames[" + index + "]), rs.wasNull(), " + this.getName() + ".class)");
        }
        return index + 1;
    }

    @Override
    public int generateLoadForeign(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        if (this._isOrdinal) {
            out.print("(" + this.getName() + ") com.caucho.amber.type.EnumType.toEnum(" + rs + ".getInt(" + indexVar + " + " + index + "), " + rs + ".wasNull(), " + this.getName() + ".values())");
        } else {
            out.print("(" + this.getName() + ") com.caucho.amber.type.EnumType.toEnum(" + rs + ".getString(" + indexVar + " + " + index + "), " + rs + ".wasNull(), " + this.getName() + ".class)");
        }
        return index + 1;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        if (this._isOrdinal) {
            out.println("if (" + value + " == null)");
            out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.INTEGER);");
            out.println("else");
            out.println("  " + pstmt + ".setInt(" + index + "++, " + value + ".ordinal());");
        } else if (pstmt.startsWith("query")) {
            out.println(pstmt + ".setString(" + index + "++, " + value + ");");
        } else {
            out.println("StringType.setString(" + pstmt + ", " + index + "++, " + value + ");");
        }
    }

    @Override
    public void setParameter(PreparedStatement pstmt, int index, Object value) throws SQLException {
        if (this._isOrdinal) {
            if (value == null) {
                pstmt.setNull(index, 4);
            } else {
                pstmt.setInt(index, ((Enum)value).ordinal());
            }
        } else if (value == null) {
            pstmt.setNull(index, 1111);
        } else {
            pstmt.setString(index, value.toString());
        }
    }

    @Override
    public String toObject(String value) {
        return value;
    }

    @Override
    public String generateCastFromObject(String value) {
        return value + ".ordinal()";
    }

    public static Object toEnum(int ordinal, boolean wasNull, Object[] values) {
        if (wasNull) {
            return null;
        }
        return values[ordinal];
    }

    public static Object toEnum(String name, boolean wasNull, Class cl) {
        if (wasNull) {
            return null;
        }
        return Enum.valueOf(cl, name);
    }

    @Override
    public Object getObject(ResultSet rs, int index) throws SQLException {
        if (this._isOrdinal) {
            Object[] values = this.getValues();
            if (values == null) {
                return null;
            }
            int v = rs.getInt(index);
            return rs.wasNull() ? null : values[v];
        }
        Class cl = this.getBeanClass();
        String name = rs.getString(index);
        return rs.wasNull() ? null : Enum.valueOf(cl, name);
    }

    @Override
    public Object toObject(long value) {
        if (this._isOrdinal) {
            Object[] values = this.getValues();
            if (values == null) {
                return null;
            }
            return values[(int)value];
        }
        return null;
    }

    private Object[] getValues() {
        try {
            Class cl = this.getBeanClass();
            Method method = cl.getDeclaredMethod("values", new Class[0]);
            Object object = method.invoke((Object)cl, new Object[0]);
            return (Object[])object;
        }
        catch (Exception e) {
            log.log(Level.FINE, e.toString(), e);
            return null;
        }
    }
}

