/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.type;

import com.caucho.amber.AmberException;
import com.caucho.amber.type.AmberType;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.sql.ResultSet;
import java.sql.SQLException;

public class ClassType
extends AmberType {
    private static final L10N L = new L10N(ClassType.class);
    private static final ClassType CLASS_TYPE = new ClassType();

    private ClassType() {
    }

    public static ClassType create() {
        return CLASS_TYPE;
    }

    @Override
    public String getName() {
        return "java.lang.Class";
    }

    @Override
    public int generateLoad(JavaWriter out, String rs, String indexVar, int index) throws IOException {
        out.print("com.caucho.amber.type.ClassType.toClass(" + rs + ".getString(" + indexVar + " + " + index + "))");
        return index + 1;
    }

    @Override
    public void generateSet(JavaWriter out, String pstmt, String index, String value) throws IOException {
        out.println("if (" + value + " == null)");
        out.println("  " + pstmt + ".setNull(" + index + "++, java.sql.Types.VARCHAR);");
        out.println("else");
        out.println("  " + pstmt + ".setString(" + index + "++, " + value + ".getName());");
    }

    @Override
    public void generateSetNull(JavaWriter out, String pstmt, String index) throws IOException {
        out.println(pstmt + ".setNull(" + index + "++, java.sql.Types.VARCHAR);");
    }

    public static Class toClass(String name) throws SQLException {
        if (name == null) {
            return null;
        }
        try {
            ClassLoader loader = Thread.currentThread().getContextClassLoader();
            return Class.forName(name, false, loader);
        }
        catch (ClassNotFoundException e) {
            throw new AmberException(e);
        }
    }

    @Override
    public Object getObject(ResultSet rs, int index) throws SQLException {
        return ClassType.toClass(rs.getString(index));
    }
}

