/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.manager;

import com.caucho.amber.AmberException;
import com.caucho.amber.AmberRuntimeException;
import com.caucho.amber.cfg.AmberConfigManager;
import com.caucho.amber.cfg.EmbeddableIntrospector;
import com.caucho.amber.cfg.EntityMappingsConfig;
import com.caucho.amber.cfg.MappedSuperIntrospector;
import com.caucho.amber.cfg.NamedNativeQueryConfig;
import com.caucho.amber.cfg.SqlResultSetMappingConfig;
import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.AmberEntityHome;
import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.entity.EntityKey;
import com.caucho.amber.entity.Listener;
import com.caucho.amber.gen.AmberGenerator;
import com.caucho.amber.gen.AmberGeneratorImpl;
import com.caucho.amber.idgen.IdGenerator;
import com.caucho.amber.idgen.SequenceIdGenerator;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.manager.AmberContainer;
import com.caucho.amber.manager.CacheConnection;
import com.caucho.amber.query.AbstractQuery;
import com.caucho.amber.query.QueryCacheKey;
import com.caucho.amber.query.ResultSetCacheChunk;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.type.AbstractEnhancedType;
import com.caucho.amber.type.AmberBeanType;
import com.caucho.amber.type.AmberType;
import com.caucho.amber.type.EmbeddableType;
import com.caucho.amber.type.EntityType;
import com.caucho.amber.type.EnumType;
import com.caucho.amber.type.GeneratorTableType;
import com.caucho.amber.type.ListenerType;
import com.caucho.amber.type.MappedSuperclassType;
import com.caucho.amber.type.SubEntityType;
import com.caucho.amber.type.SubListenerType;
import com.caucho.amber.type.TypeManager;
import com.caucho.config.ConfigException;
import com.caucho.java.gen.JavaClassGenerator;
import com.caucho.jdbc.JdbcMetaData;
import com.caucho.naming.Jndi;
import com.caucho.util.L10N;
import com.caucho.util.LruCache;
import java.io.IOException;
import java.lang.ref.SoftReference;
import java.lang.reflect.Method;
import java.sql.ResultSetMetaData;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.sql.DataSource;

public class AmberPersistenceUnit {
    private static final L10N L = new L10N(AmberPersistenceUnit.class);
    private static final Logger log = Logger.getLogger(AmberPersistenceUnit.class.getName());
    private String _name;
    private boolean _isJPA;
    private AmberContainer _amberContainer;
    private Object _entityManagerProxy;
    private DataSource _dataSource;
    private DataSource _readDataSource;
    private DataSource _xaDataSource;
    private String _jtaDataSourceName;
    private String _nonJtaDataSourceName;
    private DataSource _jtaDataSource;
    private DataSource _nonJtaDataSource;
    private JdbcMetaData _jdbcMetaData;
    private Boolean _createDatabaseTables;
    private boolean _validateDatabaseTables = true;
    private long _tableCacheTimeout = 2000L;
    private TypeManager _typeManager = new TypeManager();
    private ClassLoader _enhancedLoader;
    private HashMap<String, AmberTable> _tableMap = new HashMap();
    private HashMap<String, AmberEntityHome> _entityHomeMap = new HashMap();
    private HashMap<String, IdGenerator> _tableGenMap = new HashMap();
    private HashMap<String, SequenceIdGenerator> _sequenceGenMap = new HashMap();
    private LruCache<String, AbstractQuery> _queryParseCache = new LruCache(1024);
    private LruCache<QueryCacheKey, SoftReference<ResultSetCacheChunk>> _queryCache = new LruCache(1024);
    private LruCache<QueryCacheKey, SoftReference<ResultSetMetaData>> _queryCacheMetaData = new LruCache(16);
    private LruCache<EntityKey, SoftReference<EntityItem>> _entityCache = new LruCache(32768);
    private EntityKey _entityKey = new EntityKey();
    private ArrayList<EntityType> _lazyConfigure = new ArrayList();
    private ArrayList<EntityType> _lazyGenerate = new ArrayList();
    private ArrayList<AmberEntityHome> _lazyHomeInit = new ArrayList();
    private ArrayList<AmberTable> _lazyTable = new ArrayList();
    private HashMap<String, String> _namedQueryMap = new HashMap();
    private HashMap<String, SqlResultSetMappingConfig> _sqlResultSetMap = new HashMap();
    private HashMap<String, NamedNativeQueryConfig> _namedNativeQueryMap = new HashMap();
    private ArrayList<EntityMappingsConfig> _entityMappingsList;
    private ArrayList<EmbeddableType> _embeddableTypes = new ArrayList();
    private ArrayList<MappedSuperclassType> _mappedSuperclassTypes = new ArrayList();
    private ArrayList<ListenerType> _defaultListeners = new ArrayList();
    private AmberConfigManager _configManager;
    private EmbeddableIntrospector _embeddableIntrospector;
    private MappedSuperIntrospector _mappedSuperIntrospector;
    private AmberGenerator _generator;
    private ThreadLocal<AmberConnection> _threadConnection = new ThreadLocal();
    private volatile boolean _isInit;
    private long _xid = 1L;

    public AmberPersistenceUnit(AmberContainer container, String name) {
        this._amberContainer = container;
        this._name = name;
        this._dataSource = container.getDataSource();
        this._xaDataSource = container.getXADataSource();
        this._readDataSource = container.getReadDataSource();
        this._configManager = new AmberConfigManager(this);
        try {
            this.bindProxy();
        }
        catch (Throwable e) {
            log.log(Level.FINE, e.toString(), e);
        }
    }

    public void setName(String name) {
        this._name = name;
    }

    public String getName() {
        return this._name;
    }

    private void bindProxy() throws Exception {
    }

    public EntityManager getEntityManager() {
        return null;
    }

    public AmberContainer getAmberContainer() {
        return this._amberContainer;
    }

    public ClassLoader getTempClassLoader() {
        return this._amberContainer.getTempClassLoader();
    }

    public ClassLoader getEnhancedLoader() {
        if (this._enhancedLoader != null) {
            return this._enhancedLoader;
        }
        return this._amberContainer.getEnhancedLoader();
    }

    public void setEnhancedLoader(ClassLoader loader) {
        this._enhancedLoader = loader;
    }

    public void setDataSource(DataSource dataSource) {
        this._dataSource = dataSource;
    }

    public DataSource getDataSource() {
        if (this._jtaDataSource != null) {
            return this._jtaDataSource;
        }
        if (this._nonJtaDataSource != null) {
            return this._nonJtaDataSource;
        }
        if (this._dataSource != null) {
            return this._dataSource;
        }
        return this._amberContainer.getDataSource();
    }

    public void setReadDataSource(DataSource dataSource) {
        this._readDataSource = dataSource;
    }

    public DataSource getReadDataSource() {
        return this._readDataSource;
    }

    public void setXADataSource(DataSource dataSource) {
        this._xaDataSource = dataSource;
    }

    public DataSource getXADataSource() {
        return this._xaDataSource;
    }

    public void setJtaDataSourceName(String name) {
        this._jtaDataSourceName = name;
    }

    public void setNonJtaDataSourceName(String name) {
        this._nonJtaDataSourceName = name;
    }

    public void setJtaDataSource(DataSource dataSource) {
        this._jtaDataSource = dataSource;
    }

    public void setNonJtaDataSource(DataSource dataSource) {
        this._nonJtaDataSource = dataSource;
    }

    public boolean isJta() {
        return this._nonJtaDataSource == null || this._jtaDataSource != null;
    }

    public JdbcMetaData getMetaData() {
        if (this._jdbcMetaData == null) {
            if (this.getDataSource() == null) {
                throw new ConfigException("No data-source specified for PersistenceUnit");
            }
            this._jdbcMetaData = JdbcMetaData.create(this.getDataSource());
        }
        return this._jdbcMetaData;
    }

    public void setCreateDatabaseTables(boolean create) {
        this._createDatabaseTables = create;
    }

    public boolean getCreateDatabaseTables() {
        if (this._createDatabaseTables != null) {
            return this._createDatabaseTables;
        }
        return this._amberContainer.getCreateDatabaseTables();
    }

    public void setValidateDatabaseTables(boolean validate) {
        this._validateDatabaseTables = validate;
    }

    public boolean getValidateDatabaseTables() {
        return this._validateDatabaseTables;
    }

    public void setTableCacheTimeout(long timeout) {
        this._tableCacheTimeout = timeout;
    }

    public long getTableCacheTimeout() {
        return this._tableCacheTimeout;
    }

    public void setBytecodeGenerator(boolean isBytecodeGenerator) {
        this._generator = isBytecodeGenerator ? this._amberContainer.getGenerator() : new AmberGeneratorImpl(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public long getXid() {
        AmberPersistenceUnit amberPersistenceUnit = this;
        synchronized (amberPersistenceUnit) {
            return this._xid++;
        }
    }

    public Class loadTempClass(String className) {
        try {
            return Class.forName(className, false, this.getTempClassLoader());
        }
        catch (ClassNotFoundException e) {
            throw ConfigException.create((Throwable)e);
        }
    }

    public AmberTable createTable(String tableName) {
        AmberTable table;
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, "AmberPersistenceUnit.createTable: " + tableName);
        }
        if ((table = this._tableMap.get(tableName)) == null) {
            table = new AmberTable(this, tableName);
            table.setCacheTimeout(this.getTableCacheTimeout());
            this._tableMap.put(tableName, table);
            this._lazyTable.add(table);
        }
        return table;
    }

    public Throwable getConfigException() {
        return this._amberContainer.getConfigException();
    }

    public void addEntityClass(String className, Class type) throws ConfigException {
        if (type == null && (type = this.loadTempClass(className)) == null) {
            throw new ConfigException(L.l("'{0}' is an unknown type", (Object)className));
        }
        AmberBeanType beanType = this._configManager.introspect(type);
        if (beanType instanceof EntityType) {
            this._amberContainer.addEntity(className, (EntityType)beanType);
        }
    }

    public void addSqlResultSetMapping(String resultSetName, SqlResultSetMappingConfig resultSet) throws ConfigException {
        if (this._sqlResultSetMap.containsKey(resultSetName)) {
            throw new ConfigException(L.l("SqlResultSetMapping '{0}' is already defined.", (Object)resultSetName));
        }
        this._sqlResultSetMap.put(resultSetName, resultSet);
    }

    public SqlResultSetMappingConfig getSqlResultSetMapping(String resultSetName) {
        return this._sqlResultSetMap.get(resultSetName);
    }

    public void addNamedQuery(String name, String query) throws ConfigException {
        if (this._namedQueryMap.containsKey(name)) {
            throw new ConfigException(L.l("Named query '{0}': '{1}' is already defined.", (Object)name, (Object)query));
        }
        this._namedQueryMap.put(name, query);
    }

    public String getNamedQuery(String name) {
        return this._namedQueryMap.get(name);
    }

    public void addNamedNativeQuery(String name, NamedNativeQueryConfig queryConfig) throws ConfigException {
        if (this._namedNativeQueryMap.containsKey(name)) {
            throw new ConfigException(L.l("NamedNativeQuery '{0}' is already defined.", (Object)name));
        }
        this._namedNativeQueryMap.put(name, queryConfig);
    }

    public NamedNativeQueryConfig getNamedNativeQuery(String name) {
        return this._namedNativeQueryMap.get(name);
    }

    public EntityType createEntity(Class beanClass) {
        return this.createEntity(beanClass.getName(), beanClass);
    }

    public EntityType createEntity(String name, Class beanClass) {
        EntityType entityType = (EntityType)this._typeManager.get(name);
        if (entityType != null) {
            return entityType;
        }
        if (entityType == null) {
            EntityType parentType = null;
            for (Class parentClass = beanClass.getSuperclass(); parentType == null && parentClass != null; parentClass = parentClass.getSuperclass()) {
                parentType = (EntityType)this._typeManager.get(parentClass.getName());
            }
            entityType = parentType != null ? new SubEntityType(this, parentType) : new EntityType(this);
        }
        this._typeManager.put(name, entityType);
        if (this._typeManager.get(beanClass.getName()) == null) {
            this._typeManager.put(beanClass.getName(), entityType);
        }
        entityType.setName(name);
        entityType.setBeanClass(beanClass);
        this._lazyConfigure.add(entityType);
        AmberEntityHome entityHome = this._entityHomeMap.get(beanClass.getName());
        if (entityHome == null) {
            entityHome = new AmberEntityHome(this, entityType);
            this._lazyHomeInit.add(entityHome);
            this._isInit = false;
        }
        this.addEntityHome(name, entityHome);
        this.addEntityHome(beanClass.getName(), entityHome);
        return entityType;
    }

    public MappedSuperclassType createMappedSuperclass(String name, Class beanClass) {
        MappedSuperclassType mappedSuperType = (MappedSuperclassType)this._typeManager.get(name);
        if (mappedSuperType != null) {
            return mappedSuperType;
        }
        mappedSuperType = new MappedSuperclassType(this);
        this._typeManager.put(name, mappedSuperType);
        if (this._typeManager.get(beanClass.getName()) == null) {
            this._typeManager.put(beanClass.getName(), mappedSuperType);
        }
        this._mappedSuperclassTypes.add(mappedSuperType);
        mappedSuperType.setName(name);
        mappedSuperType.setBeanClass(beanClass);
        return mappedSuperType;
    }

    public EmbeddableType createEmbeddable(Class beanClass) {
        return this.createEmbeddable(beanClass.getName(), beanClass);
    }

    public EmbeddableType createEmbeddable(String name, Class beanClass) {
        AmberType type = this._typeManager.get(name);
        if (type != null && !(type instanceof EmbeddableType)) {
            throw new ConfigException(L.l("'{0}' is not a valid embeddable type", (Object)name));
        }
        EmbeddableType embeddableType = (EmbeddableType)type;
        if (embeddableType != null) {
            return embeddableType;
        }
        embeddableType = new EmbeddableType(this);
        this._typeManager.put(name, embeddableType);
        if (this._typeManager.get(beanClass.getName()) == null) {
            this._typeManager.put(beanClass.getName(), embeddableType);
        }
        embeddableType.setName(name);
        embeddableType.setBeanClass(beanClass);
        this._embeddableTypes.add(embeddableType);
        this._amberContainer.addEmbeddable(beanClass.getName(), embeddableType);
        return embeddableType;
    }

    public EnumType createEnum(String name, Class beanClass) {
        EnumType enumType = (EnumType)this._typeManager.get(name);
        if (enumType != null) {
            return enumType;
        }
        enumType = new EnumType();
        this._typeManager.put(name, enumType);
        if (this._typeManager.get(beanClass.getName()) == null) {
            this._typeManager.put(beanClass.getName(), enumType);
        }
        enumType.setName(name);
        enumType.setBeanClass(beanClass);
        return enumType;
    }

    public ListenerType getDefaultListener(String className) {
        return this._amberContainer.getDefaultListener(className);
    }

    public ListenerType addDefaultListener(Class beanClass) {
        ListenerType listenerType = this.getListener(beanClass);
        if (!this._defaultListeners.contains(listenerType)) {
            this._defaultListeners.add(listenerType);
            this._amberContainer.addDefaultListener(beanClass.getName(), listenerType);
        }
        return listenerType;
    }

    public ListenerType getEntityListener(String className) {
        return this._amberContainer.getEntityListener(className);
    }

    public ListenerType addEntityListener(String entityName, Class listenerClass) {
        ListenerType listenerType = this.getListener(listenerClass);
        this._amberContainer.addEntityListener(entityName, listenerType);
        return listenerType;
    }

    private ListenerType getListener(Class beanClass) {
        String name = beanClass.getName();
        ListenerType listenerType = (ListenerType)this._typeManager.get(name);
        if (listenerType != null) {
            return listenerType;
        }
        listenerType = new ListenerType(this);
        ListenerType parentType = null;
        for (Class parentClass = beanClass.getSuperclass(); parentType == null && parentClass != null; parentClass = parentClass.getSuperclass()) {
            parentType = (ListenerType)this._typeManager.get(parentClass.getName());
        }
        listenerType = parentType != null ? new SubListenerType(this, parentType) : new ListenerType(this);
        this._typeManager.put(name, listenerType);
        listenerType.setName(name);
        listenerType.setBeanClass(beanClass);
        return listenerType;
    }

    private void addEntityHome(String name, AmberEntityHome home) {
        this._entityHomeMap.put(name, home);
    }

    public IdGenerator getTableGenerator(String name) {
        return this._tableGenMap.get(name);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IdGenerator putTableGenerator(String name, IdGenerator gen) {
        HashMap<String, IdGenerator> hashMap = this._tableGenMap;
        synchronized (hashMap) {
            IdGenerator oldGen = this._tableGenMap.get(name);
            if (oldGen != null) {
                return oldGen;
            }
            this._tableGenMap.put(name, gen);
            return gen;
        }
    }

    public GeneratorTableType createGeneratorTable(String name) {
        AmberType type = this._typeManager.get(name);
        if (type instanceof GeneratorTableType) {
            return (GeneratorTableType)type;
        }
        if (type != null) {
            throw new RuntimeException(L.l("'{0}' is a duplicate generator table.", (Object)type));
        }
        GeneratorTableType genType = new GeneratorTableType(this, name);
        this._typeManager.put(name, genType);
        return genType;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public SequenceIdGenerator createSequenceGenerator(String name, int size) throws ConfigException {
        HashMap<String, SequenceIdGenerator> hashMap = this._sequenceGenMap;
        synchronized (hashMap) {
            SequenceIdGenerator gen = this._sequenceGenMap.get(name);
            if (gen == null) {
                gen = new SequenceIdGenerator(this, name, size);
                this._sequenceGenMap.put(name, gen);
            }
            return gen;
        }
    }

    public void initType(AbstractEnhancedType type) throws Exception {
        type.init();
        this.getGenerator().generate(type);
    }

    public void generate() throws Exception {
        this.configure();
        Object type = null;
        try {
            for (MappedSuperclassType mappedType : this._mappedSuperclassTypes) {
                type = mappedType;
                this.initType(mappedType);
            }
            while (this._lazyGenerate.size() > 0) {
                Iterator<ListenerType> entityType = this._lazyGenerate.remove(0);
                type = entityType;
                this.initType((AbstractEnhancedType)((Object)entityType));
                String className = ((AbstractEnhancedType)((Object)entityType)).getBeanClass().getName();
                ArrayList<ListenerType> listeners = this._amberContainer.getEntityListeners(className);
                if (listeners == null) continue;
                for (ListenerType listenerType : listeners) {
                    type = listenerType;
                    this.initType(listenerType);
                }
            }
            for (EmbeddableType embeddableType : this._embeddableTypes) {
                type = embeddableType;
                this.initType(embeddableType);
            }
            for (ListenerType listenerType : this._defaultListeners) {
                type = listenerType;
                this.initType(listenerType);
            }
        }
        catch (Exception e) {
            if (type != null) {
                ((AbstractEnhancedType)type).setConfigException(e);
                this._amberContainer.addEntityException(((AbstractEnhancedType)type).getBeanClass().getName(), e);
            }
            throw e;
        }
        try {
            this.getGenerator().compile();
        }
        catch (Exception e) {
            this._amberContainer.addException(e);
            throw e;
        }
    }

    public boolean isJPA() {
        return this._isJPA;
    }

    public void setJPA(boolean isJPA) {
        this._isJPA = isJPA;
    }

    public void generate(JavaClassGenerator javaGen) throws Exception {
        Object type;
        this.configure();
        while (this._lazyGenerate.size() > 0) {
            Iterator<SequenceIdGenerator> entityType;
            type = this._lazyGenerate.remove(0);
            ((EntityType)type).init();
            if (type instanceof EntityType && !((AbstractEnhancedType)((Object)(entityType = type))).isGenerated()) {
                if (((AbstractEnhancedType)((Object)entityType)).getInstanceClassName() == null) {
                    throw new ConfigException(L.l("'{0}' does not have a configured instance class.", entityType));
                }
                ((AbstractEnhancedType)((Object)entityType)).setGenerated(true);
                try {
                    this.getGenerator().generateJava(javaGen, (AbstractEnhancedType)((Object)entityType));
                }
                catch (Exception e) {
                    log.log(Level.FINER, e.toString(), e);
                }
            }
            this.configure();
        }
        for (EmbeddableType embeddableType : this._embeddableTypes) {
            embeddableType.init();
            if (embeddableType.isGenerated()) continue;
            if (embeddableType.getInstanceClassName() == null) {
                throw new ConfigException(L.l("'{0}' does not have a configured instance class.", (Object)embeddableType));
            }
            embeddableType.setGenerated(true);
            try {
                this.getGenerator().generateJava(javaGen, embeddableType);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        for (SequenceIdGenerator gen : this._sequenceGenMap.values()) {
            gen.init(this);
        }
        while (this._defaultListeners.size() > 0) {
            type = this._defaultListeners.remove(0);
            ((AmberType)type).init();
            if (((AbstractEnhancedType)type).isGenerated()) continue;
            if (((AbstractEnhancedType)type).getInstanceClassName() == null) {
                throw new ConfigException(L.l("'{0}' does not have a configured instance class.", type));
            }
            ((AbstractEnhancedType)type).setGenerated(true);
            try {
                this.getGenerator().generateJava(javaGen, (AbstractEnhancedType)type);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
    }

    public EmbeddableIntrospector getEmbeddableIntrospector() {
        return this._embeddableIntrospector;
    }

    public void configure() throws Exception {
        this._configManager.configure();
        while (this._lazyConfigure.size() > 0) {
            EntityType type = this._lazyConfigure.remove(0);
            if (type.startConfigure()) {
                // empty if block
            }
            this._configManager.configure();
            if (this._lazyGenerate.contains(type)) continue;
            this._lazyGenerate.add(type);
        }
        this.updateFlushPriority();
    }

    public AmberEntityHome getEntityHome(String name) {
        if (!this._isInit) {
            try {
                this.initEntityHomes();
            }
            catch (RuntimeException e) {
                throw e;
            }
            catch (Exception e) {
                throw new AmberRuntimeException(e);
            }
        }
        return this._entityHomeMap.get(name);
    }

    public AmberEntityHome getHomeBySchema(String name) {
        for (AmberEntityHome home : this._entityHomeMap.values()) {
            if (!name.equals(home.getEntityType().getName())) continue;
            return home;
        }
        try {
            this.createType(name);
        }
        catch (Exception exception) {
            // empty catch block
        }
        return this._entityHomeMap.get(name);
    }

    public EmbeddableType getEmbeddable(String className) {
        AmberType type = this._typeManager.get(className);
        if (type instanceof EmbeddableType) {
            return (EmbeddableType)type;
        }
        return null;
    }

    public EntityType getEntityType(Class cl) {
        return this.getEntityType(cl.getName());
    }

    public EntityType getEntityType(String className) {
        AmberType type = this._typeManager.get(className);
        if (type instanceof EntityType) {
            return (EntityType)type;
        }
        return null;
    }

    public MappedSuperclassType getMappedSuperclass(String className) {
        AmberType type = this._typeManager.get(className);
        if (type instanceof MappedSuperclassType) {
            return (MappedSuperclassType)type;
        }
        return null;
    }

    public EntityType getEntityByInstanceClass(String className) {
        return this._typeManager.getEntityByInstanceClass(className);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateFlushPriority() {
        ArrayList<EntityType> updatingEntities = new ArrayList<EntityType>();
        try {
            HashMap<String, AmberType> typeMap = this._typeManager.getTypeMap();
            Collection<AmberType> types = typeMap.values();
            for (AmberType type : types) {
                EntityType entityType;
                if (!(type instanceof EntityType) || updatingEntities.contains(entityType = (EntityType)type)) continue;
                updatingEntities.add(entityType);
                entityType.updateFlushPriority(updatingEntities);
            }
        }
        finally {
            updatingEntities = null;
        }
    }

    public AmberType createType(String typeName) throws ConfigException {
        AmberType type = this._typeManager.get(typeName);
        if (type != null) {
            return type;
        }
        Class cl = this.loadTempClass(typeName);
        if (cl == null) {
            throw new ConfigException(L.l("'{0}' is an unknown type", (Object)typeName));
        }
        return this.createType(cl);
    }

    public AmberType createType(Class javaType) throws ConfigException {
        AmberType type = this._typeManager.create(javaType);
        if (type != null) {
            return type;
        }
        return this.createEntity(javaType);
    }

    public AmberGenerator getGenerator() {
        if (this._generator != null) {
            return this._generator;
        }
        this._generator = this._amberContainer.getGenerator();
        return this._generator;
    }

    public String getFalseLiteral() {
        return this.getMetaData().getFalseLiteral();
    }

    public boolean hasPositionFunction() {
        return this.getMetaData().supportsPositionFunction();
    }

    public boolean hasReturnGeneratedKeys() {
        return this.getMetaData().supportsGetGeneratedKeys();
    }

    public void setEntityMappingsList(ArrayList<EntityMappingsConfig> entityMappingsList) {
    }

    public void init() throws ConfigException, IOException {
        this.initLoaders();
        if (this._dataSource == null) {
            return;
        }
    }

    public void initLoaders() throws ConfigException, IOException {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initEntityHomes() throws AmberRuntimeException, ConfigException {
        ArrayList<AmberEntityHome> homeList;
        AmberPersistenceUnit amberPersistenceUnit = this;
        synchronized (amberPersistenceUnit) {
            if (this._isInit) {
                return;
            }
            this._isInit = true;
            homeList = new ArrayList<AmberEntityHome>(this._lazyHomeInit);
            this._lazyHomeInit.clear();
        }
        if (this._jtaDataSourceName != null && this._jtaDataSource == null) {
            this._jtaDataSource = (DataSource)Jndi.lookup((String)this._jtaDataSourceName);
        }
        if (this._nonJtaDataSourceName != null && this._nonJtaDataSource == null) {
            this._nonJtaDataSource = (DataSource)Jndi.lookup((String)this._nonJtaDataSourceName);
        }
        this.initTables();
        Collections.sort(homeList);
        for (AmberEntityHome home : homeList) {
            home.init();
        }
    }

    public void initTables() throws ConfigException {
        for (IdGenerator gen : this._tableGenMap.values()) {
            gen.start();
        }
        while (this._lazyTable.size() > 0) {
            AmberTable table = this._lazyTable.remove(0);
            if (this.getDataSource() == null) {
                throw new ConfigException(L.l("{0}: No configured data-source found.", (Object)this));
            }
            if (this.getCreateDatabaseTables()) {
                table.createDatabaseTable(this);
            }
            if (!this.getValidateDatabaseTables()) continue;
            table.validateDatabaseTable(this);
        }
    }

    public CacheConnection getCacheConnection() {
        CacheConnection cacheConnection = new CacheConnection(this);
        cacheConnection.register();
        return cacheConnection;
    }

    public AmberConnection createAmberConnection(boolean isExtended) {
        return new AmberConnection(this, isExtended);
    }

    public AmberConnection getThreadConnection(boolean isExtended) {
        AmberConnection aConn = this._threadConnection.get();
        if (aConn == null) {
            aConn = new AmberConnection(this, isExtended);
            aConn.initThreadConnection();
            this._threadConnection.set(aConn);
        }
        return aConn;
    }

    public void removeThreadConnection() {
        this._threadConnection.set(null);
    }

    public AmberEntityHome getHome(Class cl) {
        return this.getEntityHome(cl.getName());
    }

    public AbstractQuery getQueryParseCache(String sql) {
        return (AbstractQuery)this._queryParseCache.get((Object)sql);
    }

    public void putQueryParseCache(String sql, AbstractQuery query) {
        this._queryParseCache.put((Object)sql, (Object)query);
    }

    public ResultSetCacheChunk getQueryChunk(QueryCacheKey key) {
        SoftReference ref = (SoftReference)this._queryCache.get((Object)key);
        if (ref == null) {
            return null;
        }
        ResultSetCacheChunk chunk = (ResultSetCacheChunk)ref.get();
        if (chunk != null && chunk.isValid()) {
            return chunk;
        }
        return null;
    }

    public ResultSetMetaData getQueryMetaData(QueryCacheKey key) {
        SoftReference ref = (SoftReference)this._queryCacheMetaData.get((Object)key);
        if (ref == null) {
            return null;
        }
        return (ResultSetMetaData)ref.get();
    }

    protected void callListeners(int callbackIndex, Entity entity) {
        ArrayList<ListenerType> listeners;
        if (!this.isJPA()) {
            return;
        }
        String className = entity.getClass().getName();
        EntityType entityType = (EntityType)this._typeManager.get(className);
        if (!entityType.getExcludeDefaultListeners()) {
            for (ListenerType listenerType : this._defaultListeners) {
                for (Method m : listenerType.getCallbacks(callbackIndex)) {
                    Listener listener = (Listener)listenerType.getInstance();
                    listener.__caucho_callback(callbackIndex, entity);
                }
            }
        }
        if ((listeners = this._amberContainer.getEntityListeners(className)) == null) {
            return;
        }
        for (ListenerType listenerType : listeners) {
            if (!entityType.getExcludeDefaultListeners() && this._defaultListeners.contains(listenerType)) continue;
            for (Method m : listenerType.getCallbacks(callbackIndex)) {
                Listener listener = (Listener)listenerType.getInstance();
                listener.__caucho_callback(callbackIndex, entity);
            }
        }
    }

    public void putQueryChunk(QueryCacheKey key, ResultSetCacheChunk chunk) {
        this._queryCache.put((Object)key, new SoftReference<ResultSetCacheChunk>(chunk));
    }

    public void putQueryMetaData(QueryCacheKey key, ResultSetMetaData metaData) {
        this._queryCacheMetaData.put((Object)key, new SoftReference<ResultSetMetaData>(metaData));
    }

    public EntityItem getEntityItem(String homeName, Object key) throws AmberException {
        AmberEntityHome home = this.getEntityHome(homeName);
        throw new IllegalStateException("XXXX:");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityItem getEntity(EntityType rootType, Object key) {
        SoftReference ref;
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(rootType.getInstanceClass(), key);
            ref = (SoftReference)this._entityCache.get((Object)this._entityKey);
        }
        if (ref != null) {
            return (EntityItem)ref.get();
        }
        return null;
    }

    public EntityItem getEntity(EntityKey entityKey) {
        SoftReference ref = (SoftReference)this._entityCache.get((Object)entityKey);
        if (ref != null) {
            return (EntityItem)ref.get();
        }
        return null;
    }

    public EntityItem putEntity(EntityType rootType, Object key, EntityItem entity) {
        if (entity == null) {
            throw new IllegalStateException(L.l("Null entity item cannot be added to the persistence unit cache"));
        }
        SoftReference ref = new SoftReference(entity);
        EntityKey entityKey = new EntityKey(rootType.getInstanceClass(), key);
        ref = (SoftReference)this._entityCache.put((Object)entityKey, ref);
        return entity;
    }

    public EntityItem putEntity(Class cl, Object key, EntityItem entity) {
        if (entity == null) {
            throw new IllegalStateException(L.l("Null entity item cannot be added to the persistence unit cache"));
        }
        SoftReference ref = new SoftReference(entity);
        EntityKey entityKey = new EntityKey(cl, key);
        ref = (SoftReference)this._entityCache.put((Object)entityKey, ref);
        return entity;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public EntityItem removeEntity(EntityType rootType, Object key) {
        SoftReference ref;
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(rootType.getInstanceClass(), key);
            ref = (SoftReference)this._entityCache.remove((Object)this._entityKey);
        }
        if (ref != null) {
            return (EntityItem)ref.get();
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void updateCacheItem(EntityType rootType, Object key, EntityItem cacheItem) {
        if (cacheItem == null) {
            throw new IllegalStateException(L.l("Null entity item cannot be used to update the persistence unit cache"));
        }
        EntityKey entityKey = this._entityKey;
        synchronized (entityKey) {
            this._entityKey.init(rootType.getInstanceClass(), key);
            SoftReference<EntityItem> ref = new SoftReference<EntityItem>(cacheItem);
            EntityKey entityKey2 = new EntityKey(rootType.getInstanceClass(), key);
            this._entityCache.put((Object)entityKey2, ref);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void complete(ArrayList<AmberCompletion> completions) {
        int size = completions.size();
        if (size == 0) {
            return;
        }
        Object object = this._entityCache;
        synchronized (object) {
            for (LruCache.Entry entry : this._entityCache) {
                EntityKey key = (EntityKey)entry.getKey();
                SoftReference valueRef = (SoftReference)entry.getValue();
                EntityItem value = (EntityItem)valueRef.get();
                if (value == null) continue;
                AmberEntityHome entityHome = value.getEntityHome();
                EntityType entityRoot = entityHome.getEntityType();
                Object entityKey = key.getKey();
                for (int i = 0; i < size; ++i) {
                    if (!completions.get(i).complete(entityRoot, entityKey, value)) continue;
                }
            }
        }
        object = this._queryCache;
        synchronized (object) {
            Iterator iter = this._queryCache.values();
            while (iter.hasNext()) {
                SoftReference ref = (SoftReference)iter.next();
                ResultSetCacheChunk chunk = (ResultSetCacheChunk)ref.get();
                if (chunk == null) continue;
                for (int i = 0; i < size; ++i) {
                    if (!completions.get(i).complete(chunk)) continue;
                }
            }
        }
    }

    public void destroy() {
        this._typeManager = null;
        this._queryCache = null;
        this._entityCache = null;
    }

    public String getCreateColumnSQL(int sqlType, int length, int precision, int scale) {
        return this.getMetaData().getCreateColumnSQL(sqlType, length, precision, scale);
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._name + "]";
    }
}

