/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.manager;

import com.caucho.amber.manager.AmberContainer;
import com.caucho.amber.manager.AmberEntityManagerFactory;
import com.caucho.amber.manager.AmberPersistenceUnit;
import com.caucho.util.L10N;
import java.util.Map;
import java.util.logging.Logger;
import javax.persistence.EntityManagerFactory;
import javax.persistence.spi.PersistenceProvider;
import javax.persistence.spi.PersistenceUnitInfo;
import javax.persistence.spi.ProviderUtil;

public class AmberPersistenceProvider
implements PersistenceProvider {
    private static final Logger log = Logger.getLogger(AmberPersistenceProvider.class.getName());
    private static final L10N L = new L10N(AmberPersistenceProvider.class);

    public EntityManagerFactory createEntityManagerFactory(String name, Map map) {
        String providerClass;
        if (map != null && (providerClass = (String)map.get("javax.persistence.provider")) != null && !this.getClass().getName().equals(providerClass)) {
            return null;
        }
        AmberContainer container = AmberContainer.getCurrent();
        if (container == null) {
            return null;
        }
        AmberPersistenceUnit pUnit = container.getPersistenceUnit(name);
        if (pUnit != null) {
            return new AmberEntityManagerFactory(pUnit);
        }
        return null;
    }

    public EntityManagerFactory createContainerEntityManagerFactory(PersistenceUnitInfo info, Map map) {
        AmberContainer container = AmberContainer.create();
        if (container == null) {
            return null;
        }
        return container.createEntityManagerFactory(info);
    }

    public ProviderUtil getProviderUtil() {
        return null;
    }
}

