/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.field;

import com.caucho.amber.field.AbstractField;
import com.caucho.amber.field.IdField;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.type.EntityType;
import com.caucho.bytecode.JMethod;
import com.caucho.bytecode.JTypeWrapper;
import com.caucho.config.ConfigException;
import com.caucho.java.JavaWriter;
import com.caucho.util.L10N;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class EntityMapField
extends AbstractField {
    private static final L10N L = new L10N(EntityMapField.class);
    protected static final Logger log = Logger.getLogger(EntityMapField.class.getName());
    private ArrayList<AmberColumn> _indexColumns;
    private JMethod _mapMethod;
    private EntityType _targetType;
    private IdField _id;
    private IdField _index;

    public EntityMapField(EntityType entityType) {
        super(entityType);
    }

    @Override
    public void setName(String name) {
        try {
            super.setName(name);
        }
        catch (ConfigException e) {
            log.log(Level.FINEST, e.toString(), e);
        }
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        this.setJavaType(JTypeWrapper.create(Map.class, (ClassLoader)loader));
    }

    public void setTargetType(EntityType type) {
        this._targetType = type;
    }

    @Override
    public boolean isUpdateable() {
        return false;
    }

    public void setMapMethod(JMethod method) {
        this._mapMethod = method;
    }

    public void setId(IdField id) {
        this._id = id;
    }

    public void setIndex(IdField index) {
        this._index = index;
    }

    public void setIndexColumns(ArrayList<AmberColumn> columns) {
        this._indexColumns = columns;
    }

    public ArrayList<AmberColumn> getIndexColumns() {
        return this._indexColumns;
    }

    @Override
    public void generateUpdate(JavaWriter out, String mask, String pstmt, String index) throws IOException {
    }

    @Override
    public void generateLoadFromObject(JavaWriter out, String obj) throws IOException {
    }

    @Override
    public void generateUpdateFromObject(JavaWriter out, String obj) throws IOException {
    }

    public String generateLoadSelect(String id) {
        return null;
    }

    @Override
    public void generateCopyUpdateObject(JavaWriter out, String dst, String src, int updateIndex) throws IOException {
    }

    @Override
    public void generateCopyLoadObject(JavaWriter out, String dst, String src, int loadIndex) throws IOException {
    }

    @Override
    public void generateSuperGetterMethod(JavaWriter out) throws IOException {
    }

    @Override
    public void generateSuperSetterMethod(JavaWriter out) throws IOException {
    }

    @Override
    public void generateGetterMethod(JavaWriter out) throws IOException {
        if (this.getGetterMethod() != null) {
            out.println();
            out.println("public " + this.getJavaTypeName() + " " + this.getGetterName() + "()");
            out.println("{");
            out.pushDepth();
            out.println("return null;");
            out.popDepth();
            out.println("}");
        }
        if (this._mapMethod != null) {
            IdField key;
            int i;
            out.println();
            out.print("public ");
            out.print(this._mapMethod.getReturnType().getPrintName());
            out.print(" " + this._mapMethod.getName() + "(");
            out.print(this._mapMethod.getParameterTypes()[0].getPrintName());
            out.println(" a0)");
            out.println("{");
            out.pushDepth();
            out.println("if (__caucho_session == null)");
            out.println("  return null;");
            out.println();
            out.println("try {");
            out.pushDepth();
            out.println("com.caucho.amber.AmberQuery query;");
            EntityType targetType = this._targetType;
            String table = targetType.getName();
            out.print("String sql = \"SELECT o");
            out.print(" FROM " + table + " o");
            out.print(" WHERE ");
            EntityType sourceType = (EntityType)this.getSourceType();
            ArrayList<IdField> keys = sourceType.getId().getKeys();
            out.print("o." + this._index.getName() + "=?1");
            for (i = 0; i < keys.size(); ++i) {
                key = keys.get(i);
                out.print(" and ");
                out.print("o." + this._id.getName() + "." + key.getName() + "=?" + (i + 2));
            }
            out.println("\";");
            out.println("query = __caucho_session.prepareQuery(sql);");
            out.println("int index = 1;");
            this._index.getType().generateSet(out, "query", "index", "a0");
            for (i = 0; i < keys.size(); ++i) {
                key = keys.get(i);
                key.generateStatementSet(out, "query", "index", "this");
            }
            out.print("return (");
            out.print(this._mapMethod.getReturnType().getPrintName());
            out.println(") query.getSingleResult();");
            out.popDepth();
            out.println("} catch (Exception e) {");
            out.println("  throw com.caucho.amber.AmberRuntimeException.create(e);");
            out.println("}");
            out.popDepth();
            out.println("}");
        }
    }
}

