/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.expr;

import com.caucho.amber.entity.Entity;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.expr.AmberExpr;
import com.caucho.amber.expr.LoadExpr;
import com.caucho.amber.expr.PathExpr;
import com.caucho.amber.field.AmberField;
import com.caucho.amber.manager.AmberConnection;
import com.caucho.amber.query.FromItem;
import com.caucho.amber.query.QueryParser;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.LinkColumns;
import com.caucho.amber.type.EntityType;
import com.caucho.util.L10N;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Map;
import java.util.logging.Logger;

public class LoadEntityExpr
extends LoadExpr {
    private static final L10N L = new L10N(LoadEntityExpr.class);
    private static final Logger log = Logger.getLogger(LoadEntityExpr.class.getName());

    LoadEntityExpr(PathExpr expr) {
        super(expr);
    }

    public EntityType getEntityType() {
        return (EntityType)this.getType();
    }

    @Override
    public AmberExpr bindSelect(QueryParser parser) {
        this._fromItem = this._expr.bindSubPath(parser);
        if (this._fromItem == null) {
            throw new NullPointerException(this._expr.getClass().getName() + " " + this._expr);
        }
        EntityType type = this.getEntityType();
        if (type.getSecondaryTables().size() > 0) {
            for (AmberField field : type.getFields()) {
                AmberTable subTable = field.getTable();
                if (subTable == null || subTable == type.getTable()) continue;
                LinkColumns link = subTable.getDependentIdLink();
                FromItem item = parser.createDependentFromItem(this._fromItem, link);
                this._subItems.add(item);
            }
        }
        return this;
    }

    @Override
    public Object getObject(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        return this.getEntityType().getLoadObject(aConn, rs, index);
    }

    @Override
    public Object getCacheObject(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        return this.getCacheObject(aConn, rs, index, null);
    }

    public Object getCacheObject(AmberConnection aConn, ResultSet rs, int index, Map<AmberExpr, String> joinFetchMap) throws SQLException {
        return this.findItem(aConn, rs, index, joinFetchMap);
    }

    @Override
    public EntityItem findItem(AmberConnection aConn, ResultSet rs, int index) throws SQLException {
        return this.findItem(aConn, rs, index, null);
    }

    public EntityItem findItem(AmberConnection aConn, ResultSet rs, int index, Map<AmberExpr, String> joinFetchMap) throws SQLException {
        EntityType entityType = this.getEntityType();
        EntityItem item = entityType.getHome().findItem(aConn, rs, index);
        if (item == null) {
            return null;
        }
        int offset = entityType.getId().getKeyCount();
        Entity entity = item.getEntity();
        this._index = entity.__caucho_load(aConn, rs, index + offset);
        item.setNumberOfLoadingColumns(this._index);
        return item;
    }
}

