/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.entity;

import com.caucho.amber.entity.AmberCompletion;
import com.caucho.amber.entity.EntityItem;
import com.caucho.amber.query.ResultSetCacheChunk;
import com.caucho.amber.type.EntityType;
import com.caucho.util.L10N;
import com.caucho.util.Log;
import java.util.logging.Level;
import java.util.logging.Logger;

public class RowInvalidateCompletion
implements AmberCompletion {
    private static final L10N L = new L10N(RowInvalidateCompletion.class);
    private static final Logger log = Log.open(RowInvalidateCompletion.class);
    private String _table;
    private Object _key;

    public RowInvalidateCompletion(String table, Object key) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, L.l("RowInvalidateCompletion table: {0} key: {1}", (Object)table, key));
        }
        if (table == null || key == null) {
            throw new NullPointerException();
        }
        this._table = table;
        this._key = key;
    }

    @Override
    public boolean complete(EntityType entityType, Object key, EntityItem entityItem) {
        if (log.isLoggable(Level.FINER)) {
            log.log(Level.FINER, L.l("RowInvalidateCompletion.complete"));
        }
        if (entityType.getTable().getName().equals(this._table) && this._key.equals(key)) {
            if (log.isLoggable(Level.FINER)) {
                log.log(Level.FINER, L.l("RowInvalidateCompletion expiring table: {0} key: {1}", (Object)this._table, this._key));
            }
            entityItem.expire();
        } else {
            entityItem.getEntity().__caucho_invalidate_foreign(this._table, key);
        }
        return false;
    }

    @Override
    public boolean complete(ResultSetCacheChunk chunk) {
        if (chunk.invalidate(this._table, this._key)) {
            chunk.invalidate();
            return true;
        }
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || o.getClass() != this.getClass()) {
            return false;
        }
        RowInvalidateCompletion comp = (RowInvalidateCompletion)o;
        return this._table.equals(comp._table) && this._key.equals(comp._key);
    }

    public String toString() {
        return "RowInvalidateCompletion[" + this._table + "," + this._key + "]";
    }
}

