/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.amber.cfg;

import com.caucho.amber.cfg.Completion;
import com.caucho.amber.cfg.JoinColumnConfig;
import com.caucho.amber.field.IdField;
import com.caucho.amber.table.AmberColumn;
import com.caucho.amber.table.AmberTable;
import com.caucho.amber.table.ForeignColumn;
import com.caucho.amber.type.EntityType;
import com.caucho.config.ConfigException;
import com.caucho.util.L10N;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;

abstract class AbstractConfig
implements Completion {
    private static final L10N L = new L10N(AbstractConfig.class);

    AbstractConfig() {
    }

    @Override
    public EntityType getRelatedType() {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    public String getName() {
        return "unknown";
    }

    public Class getTargetClass() {
        return Void.TYPE;
    }

    @Override
    public void complete() throws ConfigException {
        throw new UnsupportedOperationException(this.getClass().getName());
    }

    ArrayList<ForeignColumn> calculateColumns(AccessibleObject field, String fieldName, AmberTable mapTable, String prefix, EntityType type, HashMap<String, JoinColumnConfig> joinColumnsConfig) throws ConfigException {
        if (joinColumnsConfig == null || joinColumnsConfig.size() == 0) {
            return AbstractConfig.calculateColumns(mapTable, prefix, type);
        }
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        if (type.getId() == null) {
            throw AbstractConfig.error(field, L.l("Entity {0} has no primary key defined.", (Object)type.getName()));
        }
        ArrayList<IdField> idFields = type.getId().getKeys();
        int len = joinColumnsConfig.size();
        if (len != idFields.size()) {
            throw AbstractConfig.error(field, L.l("@JoinColumns for {0} do not match number of the primary key columns in {1}.  The foreign key columns must match the primary key columns.", (Object)fieldName, (Object)type.getName()));
        }
        for (JoinColumnConfig joinColumn : joinColumnsConfig.values()) {
            String name = joinColumn.getName();
            String refName = joinColumn.getReferencedColumnName();
            IdField id = this.getField(idFields, refName);
            AmberColumn column = id.getColumns().get(0);
            ForeignColumn foreignColumn = mapTable.createForeignColumn(name, column);
            columns.add(foreignColumn);
        }
        return columns;
    }

    IdField getField(ArrayList<IdField> fields, String name) {
        if (fields.size() == 1) {
            return fields.get(0);
        }
        for (IdField field : fields) {
            if (!field.getName().equals(name)) continue;
            return field;
        }
        if (name == null || name.equals("")) {
            throw new ConfigException(L.l("{0}: '{1}' requires a referencedColumnName value because it has multiple target keys.", (Object)this.getTargetClass().getSimpleName(), (Object)this.getName()));
        }
        throw new ConfigException(L.l("{0}: '{1}' is an unknown field for {2}", (Object)this.getTargetClass().getSimpleName(), (Object)name, (Object)this.getName()));
    }

    static ArrayList<ForeignColumn> calculateColumns(AmberTable mapTable, String prefix, EntityType type) {
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        EntityType parentType = type;
        ArrayList<AmberColumn> targetIdColumns = type.getId().getColumns();
        while (targetIdColumns.size() == 0 && (parentType = parentType.getParentType()) != null) {
            targetIdColumns = parentType.getId().getColumns();
        }
        for (AmberColumn key : targetIdColumns) {
            columns.add(mapTable.createForeignColumn(prefix + key.getName(), key));
        }
        return columns;
    }

    ArrayList<ForeignColumn> calculateColumns(AmberTable mapTable, EntityType type) {
        ArrayList<ForeignColumn> columns = new ArrayList<ForeignColumn>();
        EntityType parentType = type;
        ArrayList<AmberColumn> targetIdColumns = type.getId().getColumns();
        while (targetIdColumns.size() == 0 && (parentType = parentType.getParentType()) != null) {
            targetIdColumns = parentType.getId().getColumns();
        }
        for (AmberColumn key : targetIdColumns) {
            columns.add(mapTable.createForeignColumn(key.getName(), key));
        }
        return columns;
    }

    static AmberColumn findColumn(ArrayList<AmberColumn> columns, String ref) {
        if ((ref == null || ref.equals("")) && columns.size() == 1) {
            return columns.get(0);
        }
        for (AmberColumn column : columns) {
            if (!column.getName().equals(ref)) continue;
            return column;
        }
        return null;
    }

    public static String toSqlName(String name) {
        return name;
    }

    static ConfigException error(AccessibleObject field, String msg) {
        if (field instanceof Field) {
            return AbstractConfig.error((Field)field, msg);
        }
        return AbstractConfig.error((Method)field, msg);
    }

    static ConfigException error(Field field, String msg) {
        String className = field.getDeclaringClass().getName();
        int line = 0;
        if (line > 0) {
            return new ConfigException(className + ":" + line + ": " + msg);
        }
        return new ConfigException(className + "." + field.getName() + ": " + msg);
    }

    static ConfigException error(Method field, String msg) {
        String className = field.getDeclaringClass().getName();
        int line = 0;
        if (line > 0) {
            return new ConfigException(className + ":" + line + ": " + msg);
        }
        return new ConfigException(className + "." + field.getName() + ": " + msg);
    }
}

