/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.action;

import com.caucho.admin.action.AdminAction;
import com.caucho.management.server.StatServiceValue;
import com.caucho.server.admin.StatServiceValuesQueryReply;
import com.caucho.server.admin.StatSystem;
import com.caucho.server.cluster.ServletService;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.logging.Logger;

public class GetStatsAction
implements AdminAction {
    private static final Logger log = Logger.getLogger(GetStatsAction.class.getName());
    private static final L10N L = new L10N(GetStatsAction.class);

    public StatServiceValuesQueryReply execute(String[] meters, Date from, Date to) {
        StatSystem stats = StatSystem.getCurrent();
        int id = ServletService.getCurrent().getServerIndex();
        String serverIndex = id <= 9 ? "0" + Integer.toString(id) : Integer.toString(id);
        String[] meterNames = new String[meters.length];
        for (int i = 0; i < meters.length; ++i) {
            String meter = meters[i];
            meterNames[i] = serverIndex + '|' + meter;
        }
        String[] allNames = stats.getStatisticsNames();
        ArrayList<String> matchNames = new ArrayList<String>();
        for (String statName : allNames) {
            for (String meterName : meterNames) {
                if (!statName.startsWith(meterName) || matchNames.contains(statName)) continue;
                matchNames.add(statName);
            }
        }
        if (matchNames.size() == 0) {
            throw new IllegalArgumentException(L.l("unknown names {0}", Arrays.asList(meters)));
        }
        ArrayList<StatServiceValue[]> statValues = new ArrayList<StatServiceValue[]>();
        for (String match : matchNames) {
            statValues.add(stats.getStatisticsData(match, from.getTime(), to.getTime(), 1L));
        }
        String[] names = new String[matchNames.size()];
        matchNames.toArray(names);
        StatServiceValue[][] data = new StatServiceValue[statValues.size()][];
        statValues.toArray((T[])data);
        return new StatServiceValuesQueryReply(names, data);
    }
}

