/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.admin.action;

import com.caucho.admin.action.AbstractJmxAction;
import com.caucho.admin.action.AdminAction;
import com.caucho.config.ConfigException;
import com.caucho.server.admin.JmxCallQueryReply;
import com.caucho.util.L10N;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.logging.Logger;
import javax.management.JMException;
import javax.management.MBeanOperationInfo;
import javax.management.MBeanParameterInfo;
import javax.management.MBeanServer;
import javax.management.MBeanServerFactory;
import javax.management.ObjectName;

public class CallJmxAction
extends AbstractJmxAction
implements AdminAction {
    private static final Logger log = Logger.getLogger(CallJmxAction.class.getName());
    private static final L10N L = new L10N(CallJmxAction.class);

    /*
     * WARNING - void declaration
     */
    public JmxCallQueryReply execute(String pattern, String operationName, int operationIndex, String[] params) throws ConfigException, JMException, ClassNotFoundException {
        void var10_16;
        LinkedList<MBeanServer> servers = new LinkedList<MBeanServer>();
        servers.addAll(MBeanServerFactory.findMBeanServer(null));
        ObjectName nameQuery = ObjectName.getInstance(pattern);
        ObjectName subjectBean = null;
        MBeanServer subjectBeanServer = null;
        for (MBeanServer mBeanServer : servers) {
            for (ObjectName mbean : mBeanServer.queryNames(nameQuery, null)) {
                if (subjectBean != null) {
                    throw new ConfigException(L.l("multiple beans match `{0}'", (Object)pattern));
                }
                subjectBean = mbean;
                subjectBeanServer = mBeanServer;
            }
        }
        ArrayList<MBeanOperationInfo> operations = new ArrayList<MBeanOperationInfo>();
        if (subjectBean != null) {
            for (MBeanOperationInfo operation : subjectBeanServer.getMBeanInfo(subjectBean).getOperations()) {
                if (!operation.getName().equals(operationName) || operation.getSignature().length != params.length) continue;
                operations.add(operation);
            }
        }
        if (subjectBean == null) {
            throw new ConfigException(L.l("no beans match `{0}'", (Object)pattern));
        }
        if (operations.isEmpty()) {
            throw new ConfigException(L.l("bean at `{0}' does not appear to have operation `{1}' accepting `{2}' arguments", (Object)pattern, (Object)operationName, (Object)params.length));
        }
        if (operations.size() > 1 && operationIndex == -1) {
            CallJmxAction.sort(operations);
            StringBuilder stringBuilder = new StringBuilder(L.l("Multiple operations match `{0}', please specify operation name with index e.g `{0}:0`\n", (Object)operationName));
            for (int i = 0; i < operations.size(); ++i) {
                MBeanOperationInfo operation = (MBeanOperationInfo)operations.get(i);
                stringBuilder.append(operation.getName()).append(':').append(i).append('(');
                MBeanParameterInfo[] paramInfos = operation.getSignature();
                for (int j = 0; j < paramInfos.length; ++j) {
                    MBeanParameterInfo paramInfo = paramInfos[j];
                    stringBuilder.append(paramInfo.getType());
                    if (j + 1 >= paramInfos.length) continue;
                    stringBuilder.append(", ");
                }
                stringBuilder.append(')');
                if (i + 1 >= operations.size()) continue;
                stringBuilder.append('\n');
            }
            throw new ConfigException(stringBuilder.toString());
        }
        CallJmxAction.sort(operations);
        if (operationIndex > -1) {
            MBeanOperationInfo mBeanOperationInfo = (MBeanOperationInfo)operations.get(operationIndex);
        } else {
            MBeanOperationInfo mBeanOperationInfo = (MBeanOperationInfo)operations.get(0);
        }
        MBeanParameterInfo[] parameters = var10_16.getSignature();
        String[] signature = new String[parameters.length];
        for (int i = 0; i < parameters.length; ++i) {
            signature[i] = parameters[i].getType();
        }
        Object[] paramValues = new Object[parameters.length];
        for (int i = 0; i < params.length; ++i) {
            Object value;
            String param = params[i];
            if ("__NULL__".equals(param)) continue;
            String type = signature[i];
            paramValues[i] = value = CallJmxAction.toValue(type, param);
        }
        Object obj = subjectBeanServer.invoke(subjectBean, operationName, paramValues, signature);
        JmxCallQueryReply reply = new JmxCallQueryReply(subjectBean.getCanonicalName(), CallJmxAction.getSignature((MBeanOperationInfo)var10_16), String.valueOf(obj));
        return reply;
    }
}

