/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.pattern;

import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.pattern.AbstractPattern;
import org.w3c.dom.Node;

public class NSNamePattern
extends AbstractPattern {
    private NSNamePattern _match;
    private String _namespace;
    private String _local;
    private int _nodeType;

    public NSNamePattern(AbstractPattern parent, String namespace, String local, int nodeType) {
        super(parent);
        this._nodeType = nodeType;
        this._namespace = namespace != null ? namespace.intern() : "";
        this._local = local.intern();
    }

    @Override
    public double getPriority() {
        return 0.0;
    }

    @Override
    public boolean match(Node node, ExprEnvironment env) throws XPathException {
        if (node == null) {
            return false;
        }
        if (node.getNodeType() != this._nodeType) {
            return false;
        }
        String uri = node.getNamespaceURI();
        if (uri == null || !node.getNamespaceURI().equals(this._namespace)) {
            return false;
        }
        if (!node.getLocalName().equals(this._local)) {
            return false;
        }
        return this._parent == null || this._parent.match(node, env);
    }

    @Override
    public AbstractPattern copyPosition() {
        if (this._match == null) {
            AbstractPattern parent = null;
            if (this._parent != null) {
                parent = this._parent.copyPosition();
            }
            this._match = new NSNamePattern(parent, this._namespace, this._local, this._nodeType);
        }
        return this._match;
    }

    public boolean equals(Object b) {
        if (!(b instanceof NSNamePattern)) {
            return false;
        }
        NSNamePattern bPattern = (NSNamePattern)b;
        return this._nodeType == bPattern._nodeType && this._local.equals(bPattern._local) && this._namespace.equals(bPattern._namespace) && (this._parent == bPattern._parent || this._parent != null && this._parent.equals(bPattern._parent));
    }

    public String toString() {
        return this._parent + "{" + this._namespace + "}" + this._local;
    }
}

