/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xpath.expr;

import com.caucho.xml.XmlUtil;
import com.caucho.xpath.Env;
import com.caucho.xpath.Expr;
import com.caucho.xpath.ExprEnvironment;
import com.caucho.xpath.XPathException;
import com.caucho.xpath.expr.NumberVar;
import com.caucho.xpath.expr.Var;
import com.caucho.xpath.pattern.AbstractPattern;
import com.caucho.xpath.pattern.NodeIterator;
import java.util.ArrayList;
import org.w3c.dom.Node;

public class NumericExpr
extends Expr {
    private int _code;
    private Expr _left;
    private Expr _right;
    private double _value;
    private ArrayList<Expr> _args;
    private AbstractPattern _axis;
    private AbstractPattern _pattern;

    public NumericExpr(int code, Expr left, Expr right) {
        this._code = code;
        this._left = left;
        this._right = right;
    }

    public NumericExpr(int code, Expr expr) {
        this._code = code;
        this._left = expr;
    }

    public NumericExpr(double value) {
        this._code = 0;
        this._value = value;
    }

    public NumericExpr(int code, ArrayList<Expr> args) {
        this._code = code;
        this._args = args;
        if (args.size() > 0) {
            this._left = args.get(0);
        }
        if (args.size() > 1) {
            this._right = args.get(1);
        }
    }

    public NumericExpr(int code, AbstractPattern axis, AbstractPattern pattern) {
        this._code = code;
        this._axis = axis;
        this._pattern = pattern;
    }

    public NumericExpr(int code, AbstractPattern listPattern) {
        this._code = code;
        if ((code == 38 || code == 40) && listPattern != null) {
            this._axis = listPattern.copyAxis();
            this._pattern = listPattern.copyPosition();
        } else {
            this._pattern = listPattern;
        }
    }

    @Override
    public AbstractPattern getListContext() {
        switch (this._code) {
            case 38: 
            case 40: {
                return this._pattern;
            }
        }
        return null;
    }

    @Override
    public boolean isNumber() {
        return true;
    }

    public boolean isConstant() {
        return this._code == 0;
    }

    public double getValue() {
        return this._value;
    }

    @Override
    public Var evalVar(Node node, ExprEnvironment env) throws XPathException {
        double value = this.evalNumber(node, env);
        return NumberVar.create(value);
    }

    @Override
    public double evalNumber(Node node, ExprEnvironment env) throws XPathException {
        switch (this._code) {
            case 0: {
                return this._value;
            }
            case 21: {
                return -this._left.evalNumber(node, env);
            }
            case 22: {
                return this._left.evalNumber(node, env) + this._right.evalNumber(node, env);
            }
            case 23: {
                return this._left.evalNumber(node, env) - this._right.evalNumber(node, env);
            }
            case 24: {
                return this._left.evalNumber(node, env) * this._right.evalNumber(node, env);
            }
            case 25: {
                return this._left.evalNumber(node, env) / this._right.evalNumber(node, env);
            }
            case 26: {
                return (int)(this._left.evalNumber(node, env) / this._right.evalNumber(node, env));
            }
            case 27: {
                return this._left.evalNumber(node, env) % this._right.evalNumber(node, env);
            }
            case 33: {
                if (this._left != null) {
                    return this._left.evalNumber(node, env);
                }
                return NumericExpr.toDouble(node);
            }
            case 35: {
                return Math.floor(this._left.evalNumber(node, env));
            }
            case 36: {
                return Math.ceil(this._left.evalNumber(node, env));
            }
            case 37: {
                return Math.rint(this._left.evalNumber(node, env));
            }
            case 34: {
                return this.sum(node, env);
            }
            case 38: {
                return this.position(node, env);
            }
            case 40: {
                return this.last(node, env);
            }
            case 39: {
                return this.count(node, env);
            }
            case 48: {
                String str = this._left.evalString(node, env);
                if (str == null) {
                    return 0.0;
                }
                return str.length();
            }
        }
        throw new RuntimeException("unknown code: " + (char)this._code);
    }

    private int position(Node node, ExprEnvironment env) throws XPathException {
        int position = env.getContextPosition();
        if (position > 0) {
            return position;
        }
        if (this._axis == null || !(env instanceof Env)) {
            throw new RuntimeException("position called with no context");
        }
        if (this._pattern == null) {
            return this._axis.position(node, (Env)env, null);
        }
        return this._axis.position(node, (Env)env, this._pattern.copyPosition());
    }

    private int last(Node node, ExprEnvironment env) throws XPathException {
        int size = env.getContextSize();
        if (size > 0) {
            return size;
        }
        if (this._axis == null || !(env instanceof Env)) {
            throw new RuntimeException("last called with no context");
        }
        if (this._pattern == null) {
            return this._axis.position(node, (Env)env, null);
        }
        return this._axis.count(node, (Env)env, this._pattern.copyPosition());
    }

    private int count(Node node, ExprEnvironment env) throws XPathException {
        int count = 0;
        NodeIterator iter = this._pattern.selectUnique(node, env);
        while (iter.hasNext()) {
            iter.next();
            ++count;
        }
        return count;
    }

    private double sum(Node node, ExprEnvironment env) throws XPathException {
        double sum = 0.0;
        NodeIterator iter = this._pattern.selectUnique(node, env);
        while (iter.hasNext()) {
            Node subnode = (Node)iter.next();
            String textValue = XmlUtil.textValue(subnode);
            sum += NumericExpr.stringToNumber(textValue);
        }
        return sum;
    }

    @Override
    public boolean evalBoolean(Node node, ExprEnvironment env) throws XPathException {
        double value = this.evalNumber(node, env);
        return value != 0.0 && !Double.isNaN(value);
    }

    @Override
    public String evalString(Node node, ExprEnvironment env) throws XPathException {
        double value = this.evalNumber(node, env);
        if ((double)((int)value) == value) {
            return String.valueOf((int)value);
        }
        return String.valueOf(value);
    }

    @Override
    public Object evalObject(Node node, ExprEnvironment env) throws XPathException {
        return new Double(this.evalNumber(node, env));
    }

    public String toString() {
        switch (this._code) {
            case 0: {
                return String.valueOf(this._value);
            }
            case 21: {
                return "-" + this._left;
            }
            case 22: {
                return "(" + this._left + " + " + this._right + ")";
            }
            case 23: {
                return "(" + this._left + " - " + this._right + ")";
            }
            case 24: {
                return "(" + this._left + " * " + this._right + ")";
            }
            case 25: {
                return "(" + this._left + " div " + this._right + ")";
            }
            case 26: {
                return "(" + this._left + " quo " + this._right + ")";
            }
            case 27: {
                return "(" + this._left + " mod " + this._right + ")";
            }
            case 33: {
                return "number(" + this._left + ")";
            }
            case 34: {
                return "sum(" + this._pattern + ")";
            }
            case 35: {
                return "floor(" + this._left + ")";
            }
            case 36: {
                return "ceiling(" + this._left + ")";
            }
            case 37: {
                return "round(" + this._left + ")";
            }
            case 38: {
                return "position()";
            }
            case 39: {
                return "count(" + this._pattern + ")";
            }
            case 40: {
                return "last()";
            }
            case 48: {
                return "string-length(" + this._left + ")";
            }
        }
        return super.toString();
    }
}

