/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream.events;

import com.caucho.xml.stream.events.XMLEventImpl;
import java.io.IOException;
import java.io.Writer;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartDocument;

public class StartDocumentImpl
extends XMLEventImpl
implements StartDocument {
    private final boolean _encodingSet;
    private final String _characterEncodingScheme;
    private final String _systemId;
    private final String _version;
    private final boolean _isStandalone;
    private final boolean _standaloneSet;

    public StartDocumentImpl() {
        this(false, null, null, "1.0", false, false);
    }

    public StartDocumentImpl(boolean encodingSet, String characterEncodingScheme, String systemId, String version, boolean isStandalone, boolean standaloneSet) {
        this._encodingSet = encodingSet;
        this._characterEncodingScheme = characterEncodingScheme;
        this._systemId = systemId;
        this._version = version;
        this._isStandalone = isStandalone;
        this._standaloneSet = standaloneSet;
    }

    @Override
    public boolean encodingSet() {
        return this._encodingSet;
    }

    @Override
    public String getCharacterEncodingScheme() {
        return this._characterEncodingScheme;
    }

    @Override
    public String getSystemId() {
        return this._systemId;
    }

    @Override
    public String getVersion() {
        return this._version;
    }

    @Override
    public boolean isStandalone() {
        return this._isStandalone;
    }

    @Override
    public boolean standaloneSet() {
        return this._standaloneSet;
    }

    @Override
    public int getEventType() {
        return 7;
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            writer.write("<?xml version=\"" + this._version + "\"");
            if (this._encodingSet) {
                writer.write(" encoding=\"" + this._characterEncodingScheme + "\"");
            }
            if (this._standaloneSet) {
                writer.write(" standalone=\"" + this._standaloneSet + "\"");
            }
            writer.write("?>");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("<?xml version=\"" + this._version + "\"");
        if (this._encodingSet) {
            sb.append(" encoding=\"" + this._characterEncodingScheme + "\"");
        }
        if (this._standaloneSet) {
            sb.append(" standalone=\"" + this._standaloneSet + "\"");
        }
        sb.append("?>");
        return sb.toString();
    }

    public boolean equals(Object o) {
        if (!(o instanceof StartDocument)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        StartDocument start = (StartDocument)o;
        if (this.getCharacterEncodingScheme() != null ? !this.getCharacterEncodingScheme().equals(start.getCharacterEncodingScheme()) : start.getCharacterEncodingScheme() != null) {
            return false;
        }
        if (this.getSystemId() != null ? !this.getSystemId().equals(start.getSystemId()) : start.getSystemId() != null) {
            return false;
        }
        if (this.getVersion() != null ? !this.getVersion().equals(start.getVersion()) : start.getVersion() != null) {
            return false;
        }
        return this.encodingSet() == start.encodingSet() && this.isStandalone() == start.isStandalone() && this.standaloneSet() == start.standaloneSet();
    }
}

