/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.xml.stream.events;

import com.caucho.xml.stream.events.XMLEventImpl;
import java.io.IOException;
import java.io.Writer;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.Attribute;

public class AttributeImpl
extends XMLEventImpl
implements Attribute {
    private final QName _name;
    private final String _value;
    private final boolean _specified;
    private final String _dtdType;

    public AttributeImpl(QName name, String value) {
        this(name, value, true);
    }

    public AttributeImpl(QName name, String value, boolean specified) {
        this(name, value, specified, "CDATA");
    }

    public AttributeImpl(QName name, String value, boolean specified, String dtdType) {
        this._name = name;
        this._value = value;
        this._specified = specified;
        this._dtdType = dtdType;
    }

    @Override
    public String getDTDType() {
        return this._dtdType;
    }

    @Override
    public QName getName() {
        return this._name;
    }

    @Override
    public String getValue() {
        return this._value;
    }

    @Override
    public boolean isSpecified() {
        return this._specified;
    }

    @Override
    public int getEventType() {
        return 10;
    }

    @Override
    public void writeAsEncodedUnicode(Writer writer) throws XMLStreamException {
        try {
            writer.write(this._name + "=\"" + this._value + "\"");
        }
        catch (IOException e) {
            throw new XMLStreamException(e);
        }
    }

    public String toString() {
        return this._name + "=\"" + this._value + "\"";
    }

    public boolean equals(Object o) {
        if (!(o instanceof Attribute)) {
            return false;
        }
        if (o == null) {
            return false;
        }
        if (this == o) {
            return true;
        }
        Attribute attr = (Attribute)o;
        return this.getName().equals(attr.getName()) && this.getDTDType().equals(attr.getDTDType()) && this.getValue().equals(attr.getValue()) && this.isSpecified() == attr.isSpecified();
    }
}

