/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.inject.Module;
import com.caucho.vfs.ClientDisconnectException;
import com.caucho.vfs.StreamImpl;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.OutputStream;
import java.net.Socket;
import java.util.logging.Level;
import java.util.logging.Logger;

@Module
public class SocketStream
extends StreamImpl {
    private static final Logger log = Logger.getLogger(SocketStream.class.getName());
    private static byte[] UNIX_NEWLINE = new byte[]{10};
    private Socket _s;
    private InputStream _is;
    private OutputStream _os;
    private boolean _needsFlush;
    private byte[] _newline = UNIX_NEWLINE;
    private boolean _throwReadInterrupts = false;
    private long _totalReadBytes;
    private long _totalWriteBytes;

    public SocketStream() {
    }

    public SocketStream(Socket s) {
        this.init(s);
    }

    public void init(Socket s) {
        this._s = s;
        this._is = null;
        this._os = null;
        this._needsFlush = false;
    }

    public void init(InputStream is, OutputStream os) {
        this._is = is;
        this._os = os;
        this._needsFlush = false;
    }

    public void setThrowReadInterrupts(boolean allowThrow) {
        this._throwReadInterrupts = allowThrow;
    }

    public boolean getThrowReadInterrupts() {
        return this._throwReadInterrupts;
    }

    public void setNewline(byte[] newline) {
        this._newline = newline;
    }

    @Override
    public byte[] getNewline() {
        return this._newline;
    }

    @Override
    public boolean hasSkip() {
        return this.canRead();
    }

    @Override
    public long skip(long n) throws IOException {
        if (this._is == null) {
            if (this._s == null) {
                return -1L;
            }
            this._is = this._s.getInputStream();
        }
        return this._is.skip(n);
    }

    @Override
    public boolean canRead() {
        return this._is != null || this._s != null;
    }

    @Override
    public int read(byte[] buf, int offset, int length) throws IOException {
        try {
            int readLength;
            if (this._is == null) {
                if (this._s == null) {
                    return -1;
                }
                this._is = this._s.getInputStream();
            }
            if ((readLength = this._is.read(buf, offset, length)) >= 0) {
                this._totalReadBytes += (long)readLength;
            }
            return readLength;
        }
        catch (InterruptedIOException e) {
            if (this._throwReadInterrupts) {
                throw e;
            }
            log.log(Level.FINEST, e.toString(), e);
        }
        catch (IOException e) {
            if (this._throwReadInterrupts) {
                throw e;
            }
            log.log(Level.FINER, e.toString(), e);
        }
        return -1;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readTimeout(byte[] buf, int offset, int length, long timeout) throws IOException {
        Socket s = this._s;
        if (s == null) {
            return -1;
        }
        int oldTimeout = s.getSoTimeout();
        try {
            int readLength;
            s.setSoTimeout((int)timeout);
            int n = readLength = this.read(buf, offset, length);
            return n;
        }
        finally {
            s.setSoTimeout(oldTimeout);
        }
    }

    @Override
    public int getAvailable() throws IOException {
        if (this._is == null) {
            if (this._s == null) {
                return -1;
            }
            this._is = this._s.getInputStream();
        }
        return this._is.available();
    }

    @Override
    public boolean canWrite() {
        return this._os != null || this._s != null;
    }

    @Override
    public void write(byte[] buf, int offset, int length, boolean isEnd) throws IOException {
        if (this._os == null) {
            if (this._s == null) {
                return;
            }
            this._os = this._s.getOutputStream();
        }
        try {
            this._needsFlush = true;
            this._os.write(buf, offset, length);
            this._totalWriteBytes += (long)length;
        }
        catch (IOException e) {
            IOException exn = ClientDisconnectException.create(this + ":" + e, e);
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw exn;
        }
    }

    @Override
    public void flush() throws IOException {
        if (this._os == null || !this._needsFlush) {
            return;
        }
        this._needsFlush = false;
        try {
            this._os.flush();
        }
        catch (IOException e) {
            try {
                this.close();
            }
            catch (IOException iOException) {
                // empty catch block
            }
            throw ClientDisconnectException.create(e);
        }
    }

    public void resetTotalBytes() {
        this._totalReadBytes = 0L;
        this._totalWriteBytes = 0L;
    }

    public long getTotalReadBytes() {
        return this._totalReadBytes;
    }

    public long getTotalWriteBytes() {
        return this._totalWriteBytes;
    }

    @Override
    public void closeWrite() throws IOException {
        OutputStream os = this._os;
        this._os = null;
        if (this._s != null) {
            try {
                this._s.shutdownOutput();
            }
            catch (UnsupportedOperationException e) {
                log.log(Level.FINEST, e.toString(), e);
            }
            catch (Exception e) {
                log.log(Level.FINER, e.toString(), e);
            }
        }
        if (os != null) {
            os.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void close() throws IOException {
        Socket s = this._s;
        this._s = null;
        OutputStream os = this._os;
        this._os = null;
        InputStream is = this._is;
        this._is = null;
        try {
            if (os != null) {
                os.close();
            }
            if (is != null) {
                is.close();
            }
        }
        finally {
            if (s != null) {
                s.close();
            }
        }
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._s + "]";
    }
}

