/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.db.io.RandomAccessStreamNio;
import com.caucho.server.util.CauchoSystem;
import com.caucho.util.CharBuffer;
import com.caucho.vfs.FileRandomAccessStream;
import com.caucho.vfs.FileReadStream;
import com.caucho.vfs.FileWriteStream;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.RandomAccessStream;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.lang.reflect.Method;
import java.nio.channels.FileChannel;
import java.nio.file.OpenOption;
import java.security.AccessControlException;
import java.util.Locale;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;

public class FilePath
extends FilesystemPath {
    private static Logger log = Logger.getLogger(FilePath.class.getName());
    private static byte[] NEWLINE = FilePath.getNewlineString().getBytes();
    private static FilesystemPath PWD;
    private static Method _isSymlink;
    private static Method _toPath;
    private static Method _fileChannelOpen;
    private File _file;
    protected boolean _isWindows;

    protected FilePath(FilesystemPath root, String userPath, String path) {
        super(root, userPath, path);
        _separatorChar = FilePath.getFileSeparatorChar();
        this._isWindows = _separatorChar == '\\';
    }

    public FilePath(String path) {
        this(null, path, FilePath.normalizePath("/", FilePath.initialPath(path), 0, FilePath.getFileSeparatorChar()));
        if (this._root == null) {
            this._root._root = this._root = new FilePath(null, "/", "/");
            if (PWD == null) {
                PWD = this._root;
            }
        }
        _separatorChar = FilesystemPath._separatorChar;
        this._isWindows = ((FilePath)this._root)._isWindows;
    }

    protected static String initialPath(String path) {
        if (path == null) {
            return FilePath.getPwd();
        }
        if (path.length() > 0 && path.charAt(0) == '/') {
            return path;
        }
        if (path.length() > 1 && path.charAt(1) == ':' && FilePath.isWindows()) {
            char ch = Character.toLowerCase(path.charAt(0));
            return "/" + ch + ":" + path.substring(2);
        }
        String dir = FilePath.getPwd();
        if (dir.length() > 0 && dir.charAt(dir.length() - 1) == '/') {
            return dir + path;
        }
        return dir + "/" + path;
    }

    public static String getPwd() {
        String path = FilePath.getUserDir();
        path = path.replace(FilePath.getFileSeparatorChar(), '/');
        if (FilePath.isWindows()) {
            path = FilePath.convertFromWindowsPath(path);
        }
        return path;
    }

    private static String convertFromWindowsPath(String path) {
        char ch;
        int colon = path.indexOf(58);
        int length = path.length();
        if (colon == 1 && (ch = path.charAt(0)) != '/' && ch != '\\') {
            return "/" + ch + ":/" + path.substring(2);
        }
        if (!(length <= 1 || (ch = path.charAt(0)) != '/' && ch != '\\' || (ch = path.charAt(1)) != '/' && ch != '\\')) {
            if (colon < 0) {
                return "/:" + path;
            }
            for (int i = colon - 2; i > 1; --i) {
                ch = path.charAt(i);
                if (ch == '/' || ch == '\\') continue;
                return "/:" + path;
            }
            ch = Character.toLowerCase(path.charAt(colon - 1));
            if (ch >= 'a' && ch <= 'z') {
                return "/" + ch + path.substring(colon);
            }
            return "/:" + path;
        }
        return path;
    }

    @Override
    public long getDiskSpaceFree() {
        try {
            return this._file.getFreeSpace();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public long getDiskSpaceTotal() {
        try {
            return this._file.getTotalSpace();
        }
        catch (Exception e) {
            return 0L;
        }
    }

    @Override
    public Path schemeWalk(String userPath, Map<String, Object> attributes, String filePath, int offset) {
        if (!FilePath.isWindows()) {
            return super.schemeWalk(userPath, attributes, filePath, offset);
        }
        if (filePath.length() < offset + 2) {
            return super.schemeWalk(userPath, attributes, filePath, offset);
        }
        char ch1 = filePath.charAt(offset + 1);
        char ch2 = filePath.charAt(offset);
        return super.schemeWalk(userPath, attributes, FilePath.convertFromWindowsPath(filePath.substring(offset)), 0);
    }

    @Override
    public Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        return new FilePath(this._root, userPath, path);
    }

    @Override
    protected boolean isPathCacheable() {
        return true;
    }

    @Override
    public String getScheme() {
        return "file";
    }

    @Override
    public String getURL() {
        char ch;
        if (!FilePath.isWindows()) {
            return FilePath.escapeURL("file:" + this.getFullPath());
        }
        String path = this.getFullPath();
        int length = path.length();
        CharBuffer cb = new CharBuffer();
        cb.append("file:");
        int offset = 0;
        if (!(length >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':' && ('a' <= (ch = path.charAt(1)) && ch <= 'z' || 'A' <= ch && ch <= 'Z') || length < 3 || path.charAt(0) != '/' || path.charAt(1) != ':' || path.charAt(2) != '/')) {
            cb.append('/');
            cb.append('/');
            cb.append('/');
            cb.append('/');
            offset = 3;
        }
        while (offset < length) {
            ch = path.charAt(offset);
            if (ch == '\\') {
                cb.append('/');
            } else {
                cb.append(ch);
            }
            ++offset;
        }
        return FilePath.escapeURL(cb.toString());
    }

    @Override
    public String getNativePath() {
        char ch;
        if (!FilePath.isWindows()) {
            return this.getFullPath();
        }
        String path = this.getFullPath();
        int length = path.length();
        CharBuffer cb = new CharBuffer();
        int offset = 0;
        if (length >= 3 && path.charAt(0) == '/' && path.charAt(2) == ':' && ('a' <= (ch = path.charAt(1)) && ch <= 'z' || 'A' <= ch && ch <= 'Z')) {
            offset = 1;
        } else if (length >= 3 && path.charAt(0) == '/' && path.charAt(1) == ':' && path.charAt(2) == '/') {
            cb.append('\\');
            cb.append('\\');
            offset = 3;
        }
        while (offset < length) {
            ch = path.charAt(offset);
            if (ch == '/') {
                cb.append(_separatorChar);
            } else {
                cb.append(ch);
            }
            ++offset;
        }
        return cb.toString();
    }

    @Override
    public boolean exists() {
        try {
            if (this._isWindows && this.isAux()) {
                return false;
            }
            return this.getFile().exists();
        }
        catch (AccessControlException e) {
            log.finer(e.toString());
            return false;
        }
    }

    @Override
    public int getMode() {
        int perms = 0;
        if (this.isDirectory()) {
            perms += 512;
            perms += 73;
        }
        if (this.canRead()) {
            perms += 292;
        }
        if (this.canWrite()) {
            perms += 144;
        }
        return perms;
    }

    @Override
    public boolean isDirectory() {
        try {
            return this.getFile().isDirectory();
        }
        catch (AccessControlException e) {
            log.finer(e.toString());
            return false;
        }
    }

    @Override
    public boolean isFile() {
        try {
            if (this._isWindows && this.isAux()) {
                return false;
            }
            return this.getFile().isFile();
        }
        catch (AccessControlException e) {
            log.finer(e.toString());
            return false;
        }
    }

    @Override
    public boolean isLink() {
        try {
            return this.isLinkImpl();
        }
        catch (Throwable e) {
            if (log.isLoggable(Level.FINEST)) {
                log.finest(e.toString());
            }
            return false;
        }
    }

    private boolean isLinkImpl() throws Exception {
        return (Boolean)_isSymlink.invoke(_toPath.invoke((Object)this.getFile(), new Object[0]), new Object[0]);
    }

    @Override
    public long getLength() {
        try {
            return this.getFile().length();
        }
        catch (AccessControlException e) {
            log.finer(e.toString());
            return -1L;
        }
    }

    @Override
    public long getLastModified() {
        try {
            return this.getFile().lastModified();
        }
        catch (AccessControlException e) {
            log.finer(e.toString());
            return -1L;
        }
    }

    @Override
    public void setLastModified(long time) {
        this.getFile().setLastModified(time);
    }

    @Override
    public boolean canRead() {
        try {
            File file = this.getFile();
            if (this._isWindows && this.isAux()) {
                return false;
            }
            return file.canRead();
        }
        catch (AccessControlException e) {
            log.finer(e.toString());
            return false;
        }
    }

    @Override
    public boolean canWrite() {
        try {
            File file = this.getFile();
            if (this._isWindows && this.isAux()) {
                return false;
            }
            return file.canWrite();
        }
        catch (AccessControlException e) {
            log.finer(e.toString());
            return false;
        }
    }

    @Override
    public String[] list() throws IOException {
        try {
            String[] list = this.getFile().list();
            if (list != null) {
                return list;
            }
        }
        catch (AccessControlException e) {
            log.finer(e.toString());
        }
        return new String[0];
    }

    @Override
    public boolean mkdir() throws IOException {
        boolean value = this.getFile().mkdir();
        if (!value && !this.getFile().isDirectory()) {
            throw new IOException("cannot create directory");
        }
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mkdirs() throws IOException {
        boolean value;
        File file;
        File file2 = file = this.getFile();
        synchronized (file2) {
            value = file.mkdirs();
        }
        this.clearStatusCache();
        if (!value && !file.isDirectory()) {
            throw new IOException("Cannot create directory: " + this.getFile());
        }
        return value;
    }

    @Override
    public boolean remove() {
        if (this.getFile().delete()) {
            this.clearStatusCache();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean truncate(long length) throws IOException {
        File file = this.getFile();
        this.clearStatusCache();
        FileOutputStream fos = new FileOutputStream(file);
        try {
            fos.getChannel().truncate(length);
            boolean bl = true;
            return bl;
        }
        finally {
            fos.close();
        }
    }

    @Override
    public boolean renameTo(Path path) {
        if (!(path instanceof FilePath)) {
            return false;
        }
        FilePath file = (FilePath)path;
        this.clearStatusCache();
        file.clearStatusCache();
        return this.getFile().renameTo(file.getFile());
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        if (this._isWindows && this.isAux()) {
            throw new FileNotFoundException(this._file.toString());
        }
        return new FileReadStream(new FileInputStream(this.getFile()), this);
    }

    @Override
    public StreamImpl openWriteImpl() throws IOException {
        FileWriteStream fws = new FileWriteStream(new FileOutputStream(this.getFile()), this);
        fws.setNewline(NEWLINE);
        return fws;
    }

    @Override
    public StreamImpl openAppendImpl() throws IOException {
        FileOutputStream fos = null;
        try {
            fos = new FileOutputStream(this.getFile().toString(), true);
        }
        catch (IOException e) {
            fos = new FileOutputStream(this.getFile().toString());
        }
        FileWriteStream fws = new FileWriteStream(fos);
        fws.setNewline(NEWLINE);
        return fws;
    }

    @Override
    public StreamImpl openReadWriteImpl() throws IOException {
        VfsStream os = new VfsStream(new FileInputStream(this.getFile()), new FileOutputStream(this.getFile()), this);
        os.setNewline(NEWLINE);
        return os;
    }

    @Override
    public RandomAccessStream openFileRandomAccess() throws IOException {
        if (this._isWindows && this.isAux()) {
            throw new FileNotFoundException(this._file.toString());
        }
        return new FileRandomAccessStream(new RandomAccessFile(this.getFile(), "rw"));
    }

    @Override
    public RandomAccessStream openMemoryMappedFile(long fileSize) throws IOException {
        if (CauchoSystem.isJdk7()) {
            return RandomAccessStreamNio.open(this, fileSize);
        }
        return null;
    }

    @Override
    public Path.FileChannelFactory fileChannelFactory() {
        return new FileChannelFactoryImpl();
    }

    @Override
    public Path copy() {
        return new FilePath(this.getRoot(), this.getUserPath(), this.getPath());
    }

    @Override
    public int hashCode() {
        return this.getFullPath().hashCode();
    }

    @Override
    public boolean equals(Object b) {
        if (this == b) {
            return true;
        }
        if (!(b instanceof FilePath)) {
            return false;
        }
        FilePath file = (FilePath)b;
        return this.getFullPath().equals(file.getFullPath());
    }

    public File getFile() {
        if (this._file != null) {
            return this._file;
        }
        this._file = new File(this.getNativePath());
        return this._file;
    }

    protected boolean isAux() {
        char ch;
        if (!this._isWindows) {
            return false;
        }
        File file = this.getFile();
        String path = this.getFullPath().toLowerCase(Locale.ENGLISH);
        int len = path.length();
        int p = path.indexOf("/aux");
        if (p >= 0 && (len <= p + 4 || path.charAt(p + 4) == '.')) {
            return true;
        }
        p = path.indexOf("/con");
        if (p >= 0 && (len <= p + 4 || path.charAt(p + 4) == '.')) {
            return true;
        }
        p = path.indexOf("/lpt");
        if (p >= 0 && (len <= p + 5 || path.charAt(p + 5) == '.') && '0' <= (ch = path.charAt(p + 4)) && ch <= '9') {
            return true;
        }
        p = path.indexOf("/nul");
        return p >= 0 && (len <= p + 4 || path.charAt(p + 4) == '.');
    }

    static {
        Method isSymlink = null;
        Method toPath = null;
        Method fileChannelOpen = null;
        try {
            Class<?> path = Class.forName("java.nio.file.Path");
            Class<?> files = Class.forName("java.nio.file.Files");
            isSymlink = files.getMethod("isSymbolicLink", path);
            toPath = File.class.getMethod("toPath", new Class[0]);
            fileChannelOpen = FileChannel.class.getMethod("open", java.nio.file.Path.class, OpenOption[].class);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        _isSymlink = isSymlink;
        _toPath = toPath;
        _fileChannelOpen = fileChannelOpen;
    }

    private class FileChannelFactoryImpl
    implements Path.FileChannelFactory {
        private FileChannelFactoryImpl() {
        }

        @Override
        public FileChannel openFileChannel(OpenOption ... options) throws IOException {
            try {
                java.nio.file.Path jdkPath = (java.nio.file.Path)_toPath.invoke((Object)FilePath.this.getFile(), new Object[0]);
                return (FileChannel)_fileChannelOpen.invoke(null, jdkPath, options);
            }
            catch (Exception e) {
                log.finer(e.toString());
                return null;
            }
        }
    }
}

