/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.Crc64;
import java.io.IOException;
import java.io.InputStream;

public class Crc64InputStream
extends InputStream {
    private final InputStream _next;
    private long _crc;
    private long _length;

    public Crc64InputStream(InputStream next) {
        this._next = next;
    }

    public long getDigest() {
        return this._crc;
    }

    public long getLength() {
        return this._length;
    }

    @Override
    public int read() throws IOException {
        int data = this._next.read();
        if (data <= 0) {
            return data;
        }
        this._crc = Crc64.generate(this._crc, data);
        ++this._length;
        return data;
    }

    @Override
    public int read(byte[] buffer, int offset, int length) throws IOException {
        int sublen = this._next.read(buffer, offset, length);
        if (sublen <= 0) {
            return 0;
        }
        this._crc = Crc64.generate(this._crc, buffer, offset, sublen);
        this._length += (long)sublen;
        return sublen;
    }

    @Override
    public void close() throws IOException {
        this._next.close();
    }

    public String toString() {
        return this.getClass().getSimpleName() + "[" + this._next + "]";
    }
}

