/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.vfs;

import com.caucho.util.L10N;
import com.caucho.vfs.FilesystemPath;
import com.caucho.vfs.Path;
import com.caucho.vfs.StreamImpl;
import com.caucho.vfs.VfsStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Map;

public class ClasspathPath
extends FilesystemPath {
    protected static L10N L = new L10N(ClasspathPath.class);

    public ClasspathPath(FilesystemPath root, String userPath, String path) {
        super(root, userPath, path);
        if (this._root == null) {
            this._root = this;
        }
    }

    @Override
    public Path fsWalk(String userPath, Map<String, Object> attributes, String path) {
        return new ClasspathPath(this._root, userPath, path);
    }

    @Override
    public String getScheme() {
        return "classpath";
    }

    @Override
    public boolean exists() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        return loader.getResource(this.getPath()) != null;
    }

    @Override
    public boolean isFile() {
        return this.exists();
    }

    @Override
    public boolean canRead() {
        return this.exists();
    }

    @Override
    public boolean isDirectory() {
        return false;
    }

    @Override
    public long getLength() {
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        URL url = loader.getResource(this.getPath());
        if (url == null) {
            return 0L;
        }
        return this.lookup(url.toString()).getLength();
    }

    @Override
    public StreamImpl openReadImpl() throws IOException {
        InputStream is;
        ClassLoader loader = Thread.currentThread().getContextClassLoader();
        String path = this.getPath();
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if ((is = loader.getResourceAsStream(path)) == null) {
            throw new FileNotFoundException(this.getFullPath());
        }
        return new VfsStream(is, null);
    }

    @Override
    public String toString() {
        return this.getURL();
    }
}

