/*
 * Decompiled with CFR 0.152.
 */
package com.caucho.util;

import com.caucho.util.CurrentTime;
import com.caucho.util.TimeInterval;

public class TimeIntervalElement
implements TimeInterval {
    private final long _starts;
    private final long _stops;
    private final long _duration;
    private final int _hashCode;
    private String _toString;

    public TimeIntervalElement(long starts, long stops) {
        this._starts = starts;
        this._stops = stops;
        this._duration = this._stops - this._starts;
        this._hashCode = this.hashLong(starts + 37L * this._stops);
        this.validate();
    }

    private void validate() {
        if (this._stops < this._starts) {
            throw new IllegalStateException(this.getClass().getName());
        }
    }

    @Override
    public final long startTime() {
        return this._starts;
    }

    @Override
    public final long stopTime() {
        return this._stops;
    }

    @Override
    public final long duration() {
        return this._duration;
    }

    @Override
    public final boolean current() {
        long now = this.intervalNow();
        return this._starts <= now && now < this._stops;
    }

    @Override
    public final boolean current(long time) {
        return this._starts <= time && time < this._stops;
    }

    @Override
    public final boolean equals(Object other) {
        if (other == null || !(other instanceof TimeInterval)) {
            return false;
        }
        TimeInterval otherInterval = (TimeInterval)other;
        return this._starts == otherInterval.startTime() && this._stops == otherInterval.stopTime();
    }

    public final int hashCode() {
        return this._hashCode;
    }

    @Override
    public final int compareTo(TimeInterval interval) {
        return this.compareWith(interval).value();
    }

    @Override
    public final int compare(TimeInterval interval1, TimeInterval interval2) {
        return interval1.compareTo(interval2);
    }

    public final TimeInterval.Comparison compareWith(TimeInterval other) {
        return TimeInterval.Comparison.comparison(this, other);
    }

    private int hashLong(long item) {
        return (int)(item ^ item >>> 32);
    }

    protected long intervalNow() {
        return CurrentTime.getCurrentTime();
    }

    @Override
    public TimeInterval getTimeInterval() {
        return this;
    }

    public String toString() {
        if (this._toString == null) {
            StringBuilder sb = new StringBuilder(this.getClass().getSimpleName());
            sb.append("[starts=").append(this._starts);
            sb.append(", stops=").append(this._stops);
            sb.append(", duration=").append(this._duration).append("]");
            this._toString = sb.toString();
        }
        return this._toString;
    }
}

